/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.config.model.v1;

import org.switchyard.component.soap.config.model.SOAPNameValueModel;
import org.switchyard.component.soap.config.model.v1.V1BasicAuthModel;
import org.switchyard.component.soap.config.model.v1.V1EndpointConfigModel;
import org.switchyard.component.soap.config.model.v1.V1InterceptorModel;
import org.switchyard.component.soap.config.model.v1.V1InterceptorsModel;
import org.switchyard.component.soap.config.model.v1.V1MtomModel;
import org.switchyard.component.soap.config.model.v1.V1NtlmAuthModel;
import org.switchyard.component.soap.config.model.v1.V1ProxyModel;
import org.switchyard.component.soap.config.model.v1.V1SOAPBindingModel;
import org.switchyard.component.soap.config.model.v1.V1SOAPContextMapperModel;
import org.switchyard.component.soap.config.model.v1.V1SOAPMessageComposerModel;
import org.switchyard.component.soap.config.model.v1.V1SOAPNameValueModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseMarshaller;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.property.v1.V1PropertiesModel;
import org.switchyard.config.model.property.v1.V1PropertyModel;

public class V1SOAPMarshaller
extends BaseMarshaller {
    public V1SOAPMarshaller(Descriptor desc) {
        super(desc);
    }

    public Model read(Configuration config) {
        Descriptor desc = this.getDescriptor();
        String name = config.getName();
        if (name.startsWith("binding")) {
            return new V1SOAPBindingModel(config, desc);
        }
        if (name.equals("contextMapper")) {
            return new V1SOAPContextMapperModel(config, desc);
        }
        if (name.equals("messageComposer")) {
            return new V1SOAPMessageComposerModel(config, desc);
        }
        if (name.equals(SOAPNameValueModel.SOAPName.mtom.name())) {
            return new V1MtomModel(config, desc);
        }
        if (name.equals(SOAPNameValueModel.SOAPName.basic.name())) {
            return new V1BasicAuthModel(config, desc);
        }
        if (name.equals(SOAPNameValueModel.SOAPName.ntlm.name())) {
            return new V1NtlmAuthModel(config, desc);
        }
        if (name.equals(SOAPNameValueModel.SOAPName.proxy.name())) {
            return new V1ProxyModel(config, desc);
        }
        if (name.equals("endpointConfig")) {
            return new V1EndpointConfigModel(config, desc);
        }
        if (name.equals("inInterceptors") || name.equals("outInterceptors")) {
            return new V1InterceptorsModel(config, desc);
        }
        if (name.equals("interceptor")) {
            return new V1InterceptorModel(config, desc);
        }
        if (name.equals("properties")) {
            return new V1PropertiesModel(config, desc);
        }
        if (name.equals("property")) {
            return new V1PropertyModel(config, desc);
        }
        for (SOAPNameValueModel.SOAPName n : SOAPNameValueModel.SOAPName.values()) {
            if (!n.name().equals(name)) continue;
            return new V1SOAPNameValueModel(config, desc);
        }
        return null;
    }
}

