/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.policy;

import javax.xml.namespace.QName;
import org.switchyard.policy.Policy;

public enum TransactionPolicy implements Policy
{
    MANAGED_TRANSACTION_GLOBAL("managedTransaction.Global"){

        @Override
        public boolean supports(Policy.PolicyType type) {
            return type == Policy.PolicyType.IMPLEMENTATION;
        }

        @Override
        public boolean isCompatibleWith(Policy target) {
            return target != MANAGED_TRANSACTION_LOCAL && target != NO_MANAGED_TRANSACTION;
        }
    }
    ,
    MANAGED_TRANSACTION_LOCAL("managedTransaction.Local"){

        @Override
        public boolean supports(Policy.PolicyType type) {
            return type == Policy.PolicyType.IMPLEMENTATION;
        }

        @Override
        public boolean isCompatibleWith(Policy target) {
            return target != MANAGED_TRANSACTION_GLOBAL && target != NO_MANAGED_TRANSACTION && target != PROPAGATES_TRANSACTION;
        }

        @Override
        public Policy getPolicyDependency() {
            return SUSPENDS_TRANSACTION;
        }
    }
    ,
    NO_MANAGED_TRANSACTION("noManagedTransaction"){

        @Override
        public boolean supports(Policy.PolicyType type) {
            return type == Policy.PolicyType.IMPLEMENTATION;
        }

        @Override
        public boolean isCompatibleWith(Policy target) {
            return target != MANAGED_TRANSACTION_GLOBAL && target != MANAGED_TRANSACTION_LOCAL && target != PROPAGATES_TRANSACTION;
        }
    }
    ,
    PROPAGATES_TRANSACTION("propagatesTransaction"){

        @Override
        public boolean supports(Policy.PolicyType type) {
            return type == Policy.PolicyType.INTERACTION;
        }

        @Override
        public boolean isCompatibleWith(Policy target) {
            return target != MANAGED_TRANSACTION_LOCAL && target != NO_MANAGED_TRANSACTION && target != SUSPENDS_TRANSACTION;
        }
    }
    ,
    SUSPENDS_TRANSACTION("suspendsTransaction"){

        @Override
        public boolean supports(Policy.PolicyType type) {
            return type == Policy.PolicyType.INTERACTION;
        }

        @Override
        public boolean isCompatibleWith(Policy target) {
            return target != PROPAGATES_TRANSACTION;
        }
    };

    private final QName _qname;

    private TransactionPolicy(String name) {
        this._qname = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", name, "sca");
    }

    @Override
    public QName getQName() {
        return this._qname;
    }

    @Override
    public String getName() {
        return this.getQName().getLocalPart();
    }

    public String toString() {
        return this.getQName().toString();
    }

    @Override
    public Policy getPolicyDependency() {
        return null;
    }
}

