/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import org.custommonkey.xmlunit.XMLAssert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.test.ArquillianUtil;
import org.switchyard.test.mixins.HTTPMixIn;

@RunWith(value=Arquillian.class)
public class BPMServiceQuickstartTest {
    private static final String SOAP_REQUEST = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n    <soap:Body>\n        <orders:submitOrder xmlns:orders=\"urn:switchyard-quickstart:bpm-service:1.0\">\n            <orderId>PO-19839-XYZ</orderId>\n            <itemId>cowbell</itemId>\n            <quantity>100</quantity>\n        </orders:submitOrder>\n    </soap:Body>\n</soap:Envelope>";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-quickstart-bpm-service");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessOrder() throws Exception {
        HTTPMixIn httpMixIn = new HTTPMixIn();
        httpMixIn.initialize();
        try {
            String response = httpMixIn.postString("http://localhost:8080/swydws/ProcessOrder", SOAP_REQUEST);
            XMLAssert.assertXpathEvaluatesTo((String)"PO-19839-XYZ", (String)"//orderId", (String)response);
            XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"//accepted", (String)response);
            XMLAssert.assertXpathEvaluatesTo((String)"Thanks for your order, it has been shipped!", (String)"//status", (String)response);
        }
        finally {
            httpMixIn.uninitialize();
        }
    }
}

