/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import org.custommonkey.xmlunit.XMLAssert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.test.ArquillianUtil;
import org.switchyard.test.mixins.HTTPMixIn;

@RunWith(value=Arquillian.class)
public class BeanServiceQuickstartTest {
    private static final String SOAP_REQUEST = "<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\">\n    <soap:Body>\n        <orders:submitOrder xmlns:orders=\"urn:switchyard-quickstart:bean-service:1.0\">\n            <order>\n                <orderId>PO-19838-XYZ</orderId>\n                <itemId>BUTTER</itemId>\n                <quantity>200</quantity>\n            </order>\n        </orders:submitOrder>\n    </soap:Body>\n</soap:Envelope>";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-quickstart-bean-service");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrders() throws Exception {
        HTTPMixIn httpMixIn = new HTTPMixIn();
        httpMixIn.initialize();
        try {
            String response = httpMixIn.postString("http://localhost:8080/quickstart-bean/OrderService", SOAP_REQUEST);
            XMLAssert.assertXpathEvaluatesTo((String)"PO-19838-XYZ", (String)"//orderAck/orderId", (String)response);
            XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"//orderAck/accepted", (String)response);
            XMLAssert.assertXpathEvaluatesTo((String)"Order Accepted", (String)"//orderAck/status", (String)response);
        }
        finally {
            httpMixIn.uninitialize();
        }
    }
}

