/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import java.io.IOException;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.test.ArquillianUtil;
import org.switchyard.test.SwitchYardTestKit;
import org.switchyard.test.mixins.HornetQMixIn;
import org.switchyard.test.quickstarts.util.ResourceDeployer;

@RunWith(value=Arquillian.class)
public class BpelServiceJmsBindingQuickstartTest {
    private static final String REQUEST_QUEUE = "HelloRequestQueue";
    private static final String REPLY_QUEUE = "HelloReplyQueue";
    private static final String USER = "guest";
    private static final String PASSWD = "guestp";
    private static final String INPUT = "<exam:sayHello xmlns:exam=\"http://www.jboss.org/bpel/examples\"><exam:input>Tomo</exam:input></exam:sayHello>";
    private static final String EXPECTED_REPLY = "<sayHelloResponse xmlns=\"http://www.jboss.org/bpel/examples\"><tns:result xmlns:tns=\"http://www.jboss.org/bpel/examples\">Hello Tomo</tns:result></sayHelloResponse>";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() throws IOException {
        ResourceDeployer.addQueue(REQUEST_QUEUE);
        ResourceDeployer.addQueue(REPLY_QUEUE);
        ResourceDeployer.addPropertiesUser(USER, PASSWD);
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-quickstart-bpel-service-jms-binding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJmsBinding() throws Exception {
        HornetQMixIn hqMixIn = new HornetQMixIn(false).setUser(USER).setPassword(PASSWD);
        hqMixIn.initialize();
        Session session = null;
        MessageProducer producer = null;
        MessageConsumer consumer = null;
        try {
            session = hqMixIn.createJMSSession();
            producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)REQUEST_QUEUE));
            ObjectMessage message = hqMixIn.createJMSMessage(INPUT);
            producer.send((Message)message);
            consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)REPLY_QUEUE));
            message = consumer.receive(3000L);
            String reply = hqMixIn.readStringFromJMSMessage((Message)message);
            SwitchYardTestKit.compareXMLToString((String)reply, (String)EXPECTED_REPLY);
        }
        finally {
            hqMixIn.uninitialize();
        }
    }

    @After
    public void undeploy() throws IOException {
        ResourceDeployer.removeQueue(REQUEST_QUEUE);
        ResourceDeployer.removeQueue(REPLY_QUEUE);
    }
}

