/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import java.util.HashMap;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.test.ArquillianUtil;
import org.switchyard.test.mixins.HTTPMixIn;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@RunWith(value=Arquillian.class)
public class BpelServiceLoanApprovalQuickstartTest {
    private static final String SOAP_REQUEST_1 = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:exam=\"http://www.jboss.org/bpel/examples\">\n   <soapenv:Header/>\n   <soapenv:Body>\n   <ns1:request xmlns:ns1=\"http://example.com/loan-approval/loanService/\">\n   <ns1:firstName>Fred</ns1:firstName>\n   <ns1:name>Bloggs</ns1:name>\n   <ns1:amount>100</ns1:amount>\n   </ns1:request>\n   </soapenv:Body>\n</soapenv:Envelope>";
    private static final String SOAP_REQUEST_2 = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:exam=\"http://www.jboss.org/bpel/examples\">\n   <soapenv:Header/>\n   <soapenv:Body>\n   <ns1:request xmlns:ns1=\"http://example.com/loan-approval/loanService/\">\n   <ns1:firstName>Fred</ns1:firstName>\n   <ns1:name>Bloggs</ns1:name>\n   <ns1:amount>11000</ns1:amount>\n   </ns1:request>\n   </soapenv:Body>\n</soapenv:Envelope>";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-quickstart-bpel-service-loan-approval");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoanRequestAccepted() throws Exception {
        HTTPMixIn httpMixIn = new HTTPMixIn();
        httpMixIn.initialize();
        try {
            String response = httpMixIn.postString("http://localhost:8080/loanService/loanService", SOAP_REQUEST_1);
            Document d = XMLUnit.buildControlDocument((String)response);
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("tns", "http://example.com/loan-approval/loanService/");
            SimpleNamespaceContext ctx = new SimpleNamespaceContext(m);
            XpathEngine engine = XMLUnit.newXpathEngine();
            engine.setNamespaceContext((NamespaceContext)ctx);
            NodeList l = engine.getMatchingNodes("//tns:accept", d);
            Assert.assertEquals((long)1L, (long)l.getLength());
            Assert.assertEquals((long)1L, (long)l.item(0).getNodeType());
            if (!l.item(0).getTextContent().equals("yes")) {
                Assert.fail((String)"Expecting 'yes'");
            }
        }
        finally {
            httpMixIn.uninitialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoanRequestUnableToHandle() throws Exception {
        HTTPMixIn httpMixIn = new HTTPMixIn();
        httpMixIn.initialize();
        try {
            String response = httpMixIn.postString("http://localhost:8080/loanService/loanService", SOAP_REQUEST_2);
            System.out.println(response);
            Document d = XMLUnit.buildControlDocument((String)response);
            HashMap m = new HashMap();
            SimpleNamespaceContext ctx = new SimpleNamespaceContext(m);
            XpathEngine engine = XMLUnit.newXpathEngine();
            engine.setNamespaceContext((NamespaceContext)ctx);
            NodeList l = engine.getMatchingNodes("//faultcode", d);
            Assert.assertEquals((long)1L, (long)l.getLength());
            Assert.assertEquals((long)1L, (long)l.item(0).getNodeType());
            if (!l.item(0).getTextContent().endsWith(":unableToHandleRequest")) {
                Assert.fail((String)"Expecting 'unableToHandleRequest' fault code");
            }
        }
        finally {
            httpMixIn.uninitialize();
        }
    }
}

