/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.test.ArquillianUtil;
import org.switchyard.test.mixins.HornetQMixIn;
import org.switchyard.test.quickstarts.util.ResourceDeployer;

@RunWith(value=Arquillian.class)
public class JCAOutboundHornetQQuickstartTest {
    private static final String ORDER_QUEUE = "OrderQueue";
    private static final String SHIPPING_QUEUE = "ShippingQueue";
    private static final String FILLING_STOCK_QUEUE = "FillingStockQueue";
    private static final String USER = "guest";
    private static final String PASSWD = "guestp";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() throws IOException {
        ResourceDeployer.addQueue(ORDER_QUEUE);
        ResourceDeployer.addQueue(SHIPPING_QUEUE);
        ResourceDeployer.addQueue(FILLING_STOCK_QUEUE);
        ResourceDeployer.addPropertiesUser(USER, PASSWD);
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-quickstart-jca-outbound-hornetq");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeployment() throws Exception {
        HornetQMixIn hqMixIn = new HornetQMixIn(false).setUser(USER).setPassword(PASSWD);
        hqMixIn.initialize();
        String[] orders = new String[]{"BREAD", "PIZZA", "JAM", "POTATO", "MILK", "JAM"};
        try {
            Session session = hqMixIn.getJMSSession();
            MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)ORDER_QUEUE));
            for (String order : orders) {
                BytesMessage message = session.createBytesMessage();
                message.writeBytes(order.getBytes());
                producer.send((Message)message);
            }
            session = hqMixIn.createJMSSession();
            MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)SHIPPING_QUEUE));
            ArrayList<String> expectedShippingOrders = new ArrayList<String>(Arrays.asList("BREAD", "JAM", "MILK", "JAM"));
            Message msg = null;
            while ((msg = consumer.receive(1000L)) != null) {
                Assert.assertTrue((boolean)expectedShippingOrders.remove(hqMixIn.readStringFromJMSMessage(msg)));
            }
            Assert.assertEquals((long)0L, (long)expectedShippingOrders.size());
            consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)FILLING_STOCK_QUEUE));
            ArrayList<String> expectedFillingStockOrders = new ArrayList<String>(Arrays.asList("PIZZA", "POTATO"));
            while ((msg = consumer.receive(1000L)) != null) {
                Assert.assertTrue((boolean)expectedFillingStockOrders.remove(hqMixIn.readStringFromJMSMessage(msg)));
            }
            Assert.assertEquals((long)0L, (long)expectedFillingStockOrders.size());
        }
        finally {
            hqMixIn.uninitialize();
            ResourceDeployer.removeQueue(ORDER_QUEUE);
            ResourceDeployer.removeQueue(SHIPPING_QUEUE);
            ResourceDeployer.removeQueue(FILLING_STOCK_QUEUE);
        }
    }
}

