/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.test.ArquillianUtil;
import org.switchyard.test.SwitchYardTestKit;
import org.switchyard.test.mixins.HTTPMixIn;

@RunWith(value=Arquillian.class)
public class RestBindingQuickstartTest {
    private static final String BASE_URL = "http://localhost:8080/rest-binding";
    private static final String SUCCESS = "SUCCESS";
    private static final String ORDER = "<order>    <orderId>1</orderId></order>";
    private static final String ORDER1 = "<order>    <orderId>1</orderId>    <orderItem>        <item>            <itemId>1</itemId>         </item>         <quantity>10</quantity>     </orderItem></order>";
    private static final String ORDER2 = "<order>    <orderId>1</orderId>    <orderItem>        <item>            <itemId>3</itemId>        </item>        <quantity>5</quantity>    </orderItem>    <orderItem>        <item>            <itemId>4</itemId>        </item>        <quantity>3</quantity>    </orderItem></order>";
    private static final String ORDER3 = "<order>    <orderId>1</orderId>    <orderItem>        <item>            <itemId>1</itemId>            <name>Hydrogen Atom - No, we are not kidding!</name>        </item>        <quantity>10</quantity>    </orderItem>    <orderItem>        <item>            <itemId>3</itemId>            <name>Einstein's Bust - Talks about your future :)</name>        </item>        <quantity>5</quantity>    </orderItem>    <orderItem>        <item>            <itemId>4</itemId>            <name>Time Machine</name>        </item>        <quantity>3</quantity>    </orderItem></order>";
    private static final String ORDER4 = "<order>    <orderId>1</orderId>    <orderItem>        <item>            <itemId>3</itemId>            <name>Einstein's Bust - Talks about your future :)</name>        </item>        <quantity>5</quantity>    </orderItem>    <orderItem>        <item>            <itemId>4</itemId>            <name>Time Machine</name>        </item>        <quantity>3</quantity>    </orderItem></order>";
    private static final String ORDER5 = "<order>    <orderId>1</orderId>    <orderItem>        <item>            <itemId>3</itemId>            <name>Theory of relativity</name>        </item>        <quantity>5</quantity>    </orderItem>    <orderItem>        <item>            <itemId>4</itemId>            <name>Coffee Maker</name>        </item>        <quantity>3</quantity>    </orderItem></order>";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-quickstart-rest-binding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrders() throws Exception {
        HTTPMixIn httpMixIn = new HTTPMixIn();
        httpMixIn.initialize();
        try {
            String response = httpMixIn.sendString("http://localhost:8080/rest-binding/inventory/create", "", "OPTIONS");
            Assert.assertEquals((Object)SUCCESS, (Object)response);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/order", "", "POST");
            SwitchYardTestKit.compareXMLToString((String)response, (String)ORDER);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/order/item", ORDER1, "PUT");
            Assert.assertEquals((Object)SUCCESS, (Object)response);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/order/item", ORDER2, "PUT");
            Assert.assertEquals((Object)SUCCESS, (Object)response);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/order/1", "", "GET");
            SwitchYardTestKit.compareXMLToString((String)response, (String)ORDER3);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/order/1:1", "", "DELETE");
            Assert.assertEquals((Object)SUCCESS, (Object)response);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/order/1", "", "GET");
            SwitchYardTestKit.compareXMLToString((String)response, (String)ORDER4);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/inventory/update", "", "OPTIONS");
            Assert.assertEquals((Object)SUCCESS, (Object)response);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/order/1", "", "GET");
            SwitchYardTestKit.compareXMLToString((String)response, (String)ORDER5);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/inventory/remove", "", "OPTIONS");
            Assert.assertEquals((Object)SUCCESS, (Object)response);
        }
        finally {
            httpMixIn.uninitialize();
        }
    }
}

