/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.domain.management.security.AddPropertiesUser;
import org.jboss.dmr.ModelNode;

public class ResourceDeployer {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 9999;
    public static final String DEFAULT_REALM = "ApplicationRealm";
    public static final String APPLICATION_ROLES_PROPERTIES = "application-roles.properties";

    private ResourceDeployer() {
    }

    public static ModelNode addQueue(String host, int port, String queueName) throws IOException {
        ModelControllerClient client = ResourceDeployer.createClient(host, port);
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").add("subsystem", "messaging");
        op.get("address").add("hornetq-server", "default");
        op.get("address").add("jms-queue", queueName);
        op.get("entries").add(queueName).add("java:jboss/exported/jms/" + queueName);
        return client.execute(op);
    }

    public static ModelNode addQueue(String queueName) throws IOException {
        return ResourceDeployer.addQueue(DEFAULT_HOST, 9999, queueName);
    }

    public static ModelNode removeQueue(String host, int port, String queueName) throws IOException {
        ModelControllerClient client = ResourceDeployer.createClient(host, port);
        ModelNode op = new ModelNode();
        op.get("operation").set("remove");
        op.get("address").add("subsystem", "messaging");
        op.get("address").add("hornetq-server", "default");
        op.get("address").add("jms-queue", queueName);
        return client.execute(op);
    }

    public static ModelNode removeQueue(String queueName) throws IOException {
        return ResourceDeployer.addQueue(DEFAULT_HOST, 9999, queueName);
    }

    public static void addPropertiesUser(String user, String passwd) throws IOException {
        AddPropertiesUser.main((String[])new String[]{"--silent=true", "-a", user, passwd, DEFAULT_REALM});
        String home = System.getenv("JBOSS_HOME");
        File roleFile = new File(home + "/standalone/configuration/" + APPLICATION_ROLES_PROPERTIES);
        BufferedReader read = new BufferedReader(new FileReader(roleFile));
        String line = null;
        while ((line = read.readLine()) != null) {
            if (!line.trim().startsWith("user")) continue;
            read.close();
            return;
        }
        BufferedWriter write = new BufferedWriter(new FileWriter(roleFile, true));
        write.newLine();
        write.append(user + "=guest");
        write.close();
    }

    private static ModelControllerClient createClient(String host, int port) throws UnknownHostException {
        return ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName(host), (int)port);
    }
}

