/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.jca;

import java.net.URL;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.common.type.Classes;
import org.switchyard.component.test.mixins.hornetq.HornetQMixIn;
import org.switchyard.test.jca.JCAJMSFault;
import org.switchyard.test.jca.JCAJMSService;
import org.switchyard.test.jca.JCAJMSServiceImpl;
import org.switchyard.test.jca.MyJMSContextMapper;
import org.switchyard.test.jca.MyJMSMessageComposer;
import org.switchyard.test.quickstarts.util.ResourceDeployer;

@RunWith(value=Arquillian.class)
public class JCAJMSServiceBindingTest {
    private static final String TEST_CONFIG = "org/switchyard/test/jca/switchyard-inbound-jms-test.xml";
    private static final String INPUT_QUEUE = "TestQueue";
    private static final String INPUT_INOUT_QUEUE = "InOutTestQueue";
    private static final String INPUT_INOUT_PHYSICAL_NAME_QUEUE = "InOutPhysicalNameTestQueue";
    private static final String INOUT_REPLY_TO_QUEUE = "InOutTestQueue_replyTo";
    private static final String INOUT_REPLY_TO_PHYSICAL_NAME_QUEUE = "InOutPhysicalNameTestQueue_replyTo";
    private static final String INOUT_FAULT_TO_QUEUE = "InOutTestQueue_faultTo";
    private static final String INOUT_FAULT_TO_PHYSICAL_NAME_QUEUE = "InOutPhysicalNameTestQueue_faultTo";
    private static final String RESULT_QUEUE = "StoreResultQueue";
    private static final String FAULT_QUEUE = "StoreFaultQueue";
    private Logger _logger = Logger.getLogger(JCAJMSServiceBindingTest.class);
    private HornetQMixIn _hqMixIn;

    @Deployment(testable=false)
    public static JavaArchive createDeployment() throws Exception {
        ResourceDeployer.addQueue(INPUT_QUEUE);
        ResourceDeployer.addQueue(INPUT_INOUT_QUEUE);
        ResourceDeployer.addQueue("InOutPhysicalNameTestQueue_physical", "InOutPhysicalNameTestQueue_jndi");
        ResourceDeployer.addQueue(INOUT_REPLY_TO_QUEUE);
        ResourceDeployer.addQueue("InOutPhysicalNameTestQueue_replyTo_physical", "InOutPhysicalNameTestQueue_replyTo_jndi");
        ResourceDeployer.addQueue(INOUT_FAULT_TO_QUEUE);
        ResourceDeployer.addQueue("InOutPhysicalNameTestQueue_faultTo_physical", "InOutPhysicalNameTestQueue_faultTo_jndi");
        ResourceDeployer.addQueue(RESULT_QUEUE);
        ResourceDeployer.addQueue(FAULT_QUEUE);
        URL testConfigUrl = Classes.getResource((String)TEST_CONFIG);
        String beansXml = ((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).exportAsString();
        return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"switchyard-JCAJMSServiceBindingTest.jar")).addClass(JCAJMSService.class)).addClass(JCAJMSServiceImpl.class)).addClass(JCAJMSFault.class)).addClass(MyJMSContextMapper.class)).addClass(MyJMSMessageComposer.class)).addAsManifestResource((Asset)new UrlAsset(testConfigUrl), "switchyard.xml")).addAsManifestResource((Asset)new StringAsset(beansXml), "beans.xml");
    }

    @Before
    public void before() {
        this._hqMixIn = new HornetQMixIn(false).setUser("guest").setPassword("Guestp123!");
        this._hqMixIn.initialize();
    }

    @After
    public void after() {
        try {
            this._hqMixIn.uninitialize();
            ResourceDeployer.removeQueue(INPUT_QUEUE);
            ResourceDeployer.removeQueue(INPUT_INOUT_QUEUE);
            ResourceDeployer.removeQueue("InOutPhysicalNameTestQueue_physical");
            ResourceDeployer.removeQueue(INOUT_REPLY_TO_QUEUE);
            ResourceDeployer.removeQueue("InOutPhysicalNameTestQueue_replyTo_physical");
            ResourceDeployer.removeQueue(INOUT_FAULT_TO_QUEUE);
            ResourceDeployer.removeQueue("InOutPhysicalNameTestQueue_faultTo_physical");
            ResourceDeployer.removeQueue(RESULT_QUEUE);
            ResourceDeployer.removeQueue(FAULT_QUEUE);
        }
        catch (Exception e) {
            this._logger.warn((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInflowJMS() throws Exception {
        Session session = this._hqMixIn.createJMSSession();
        try {
            MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)INPUT_QUEUE));
            TextMessage inMsg = session.createTextMessage();
            inMsg.setText("onMessage");
            producer.send((Message)inMsg);
            producer.close();
            session.close();
            session = this._hqMixIn.createJMSSession();
            MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)RESULT_QUEUE));
            this.assertMessage(consumer.receive(3000L), TextMessage.class, "onMessagetesttest");
            Assert.assertNull((Object)consumer.receive(3000L));
            consumer.close();
            consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)FAULT_QUEUE));
            Assert.assertNull((Object)consumer.receive(3000L));
            consumer.close();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInflowJMS_fault_rollback() throws Exception {
        Session session = this._hqMixIn.createJMSSession();
        try {
            MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)INPUT_QUEUE));
            TextMessage inMsg = session.createTextMessage();
            inMsg.setText("onMessage_fault_rollback");
            producer.send((Message)inMsg);
            producer.close();
            session.close();
            session = this._hqMixIn.createJMSSession();
            MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)FAULT_QUEUE));
            this.assertMessage(consumer.receive(3000L), TextMessage.class, "faultmessagetest");
            this.assertMessage(consumer.receive(3000L), TextMessage.class, "faultmessagetest");
            this.assertMessage(consumer.receive(3000L), TextMessage.class, "faultmessagetest");
            this.assertMessage(consumer.receive(3000L), TextMessage.class, "faultmessagetest");
            Assert.assertNull((Object)consumer.receive(3000L));
            consumer.close();
            consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)RESULT_QUEUE));
            this.assertMessage(consumer.receive(3000L), TextMessage.class, "onMessage_fault_rollbacktesttest");
            Assert.assertNull((Object)consumer.receive(3000L));
            consumer.close();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInflowJMS_fault_commit() throws Exception {
        Session session = this._hqMixIn.createJMSSession();
        try {
            MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)INPUT_QUEUE));
            TextMessage inMsg = session.createTextMessage();
            inMsg.setText("onMessage_fault_commit");
            producer.send((Message)inMsg);
            producer.close();
            session.close();
            session = this._hqMixIn.createJMSSession();
            MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)FAULT_QUEUE));
            this.assertMessage(consumer.receive(3000L), TextMessage.class, "faultmessagetest");
            Assert.assertNull((Object)consumer.receive(3000L));
            consumer.close();
            consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)RESULT_QUEUE));
            this.assertMessage(consumer.receive(3000L), TextMessage.class, "onMessage_fault_committesttest");
            Assert.assertNull((Object)consumer.receive(3000L));
            consumer.close();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInflowJMS_inout() throws Exception {
        String payload = "onMessage_inout";
        Session session = this._hqMixIn.createJMSSession();
        try {
            MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)INPUT_INOUT_QUEUE));
            TextMessage inMsg = session.createTextMessage();
            inMsg.setText(payload);
            producer.send((Message)inMsg);
            producer.close();
            session.close();
            session = this._hqMixIn.createJMSSession();
            MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)INOUT_REPLY_TO_QUEUE));
            this.assertMessage(consumer.receive(3000L), TextMessage.class, payload + "_replyTo");
            consumer.close();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInflowJMS_inout_fault() throws Exception {
        String payload = "onMessage_inout_fault";
        Session session = this._hqMixIn.createJMSSession();
        try {
            MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)INPUT_INOUT_QUEUE));
            TextMessage inMsg = session.createTextMessage();
            inMsg.setText(payload);
            producer.send((Message)inMsg);
            producer.close();
            session.close();
            session = this._hqMixIn.createJMSSession();
            MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)INOUT_FAULT_TO_QUEUE));
            this.assertMessage(consumer.receive(3000L), TextMessage.class, "org.switchyard.test.jca.JCAJMSFault: " + payload + "_faultTo");
            consumer.close();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInflowJMS_inout_context_property() throws Exception {
        String payload = "onMessage_inout_context_property";
        Session session = this._hqMixIn.createJMSSession();
        try {
            MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)INPUT_INOUT_QUEUE));
            TextMessage inMsg = session.createTextMessage();
            inMsg.setText(payload);
            producer.send((Message)inMsg);
            producer.close();
            session.close();
            session = this._hqMixIn.createJMSSession();
            MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)RESULT_QUEUE));
            this.assertMessage(consumer.receive(3000L), BytesMessage.class, payload + "_replyTo");
            consumer.close();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInflowJMS_inout_physical_name() throws Exception {
        String payload = "onMessage_inout_physical_name";
        Session session = this._hqMixIn.createJMSSession();
        try {
            MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)"InOutPhysicalNameTestQueue_physical"));
            TextMessage inMsg = session.createTextMessage();
            inMsg.setText(payload);
            producer.send((Message)inMsg);
            producer.close();
            session.close();
            session = this._hqMixIn.createJMSSession();
            MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)"InOutPhysicalNameTestQueue_replyTo_physical"));
            this.assertMessage(consumer.receive(3000L), TextMessage.class, payload + "_replyTo");
            consumer.close();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInflowJMS_inout_physical_name_fault() throws Exception {
        String payload = "onMessage_inout_physical_name_fault";
        Session session = this._hqMixIn.createJMSSession();
        try {
            MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)"InOutPhysicalNameTestQueue_physical"));
            TextMessage inMsg = session.createTextMessage();
            inMsg.setText(payload);
            producer.send((Message)inMsg);
            producer.close();
            session.close();
            session = this._hqMixIn.createJMSSession();
            MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)"InOutPhysicalNameTestQueue_faultTo_physical"));
            this.assertMessage(consumer.receive(3000L), TextMessage.class, "org.switchyard.test.jca.JCAJMSFault: " + payload + "_faultTo");
            consumer.close();
        }
        finally {
            session.close();
        }
    }

    private <T extends Message> void assertMessage(Message msg, Class<T> type, String expect) throws Exception {
        Assert.assertNotNull((Object)msg);
        Assert.assertTrue((String)("Unexpected message type: " + msg.getClass().getName()), (boolean)type.isAssignableFrom(msg.getClass()));
        if (msg instanceof TextMessage) {
            Assert.assertEquals((Object)expect, (Object)((TextMessage)TextMessage.class.cast(msg)).getText());
        } else if (msg instanceof BytesMessage) {
            BytesMessage bmsg = (BytesMessage)BytesMessage.class.cast(msg);
            byte[] bytes = new byte[(int)bmsg.getBodyLength()];
            bmsg.readBytes(bytes);
            Assert.assertEquals((Object)expect, (Object)new String(bytes));
        } else {
            Assert.fail((String)("Unexpected message type: " + msg.getClass().getName()));
        }
    }
}

