/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import java.util.HashMap;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.component.test.mixins.http.HTTPMixIn;
import org.switchyard.test.ArquillianUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@RunWith(value=Arquillian.class)
public class BpelServiceSayHelloQuickstartTest {
    private static final String SOAP_REQUEST = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:exam=\"http://www.jboss.org/bpel/examples\">\n   <soapenv:Header/>\n   <soapenv:Body>\n       <exam:sayHello>\n           <exam:input>Fred</exam:input>\n       </exam:sayHello>\n   </soapenv:Body>\n</soapenv:Envelope>";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-bpel-say-hello");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSayHello() throws Exception {
        HTTPMixIn httpMixIn = new HTTPMixIn();
        httpMixIn.initialize();
        try {
            String response = httpMixIn.postString("http://localhost:8080/SayHelloService/SayHelloService", SOAP_REQUEST);
            Document d = XMLUnit.buildControlDocument((String)response);
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("tns", "http://www.jboss.org/bpel/examples");
            SimpleNamespaceContext ctx = new SimpleNamespaceContext(m);
            XpathEngine engine = XMLUnit.newXpathEngine();
            engine.setNamespaceContext((NamespaceContext)ctx);
            NodeList l = engine.getMatchingNodes("//tns:result", d);
            Assert.assertEquals((long)1L, (long)l.getLength());
            Assert.assertEquals((long)1L, (long)l.item(0).getNodeType());
            if (!l.item(0).getTextContent().equals("Hello Fred")) {
                Assert.fail((String)"Expecting 'Hello Fred'");
            }
        }
        finally {
            httpMixIn.uninitialize();
        }
    }
}

