/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.common.type.Classes;
import org.switchyard.component.test.mixins.http.HTTPMixIn;
import org.switchyard.test.ArquillianUtil;

@RunWith(value=Arquillian.class)
public class BeanServiceQuickstartTest {
    private static final String SOAP_REQUEST = "<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\">\n    <soap:Body>\n        <orders:submitOrder xmlns:orders=\"urn:switchyard-quickstart:bean-service:1.0\">\n            <order>\n                <orderId>PO-19838-XYZ</orderId>\n                <itemId>BUTTER</itemId>\n                <quantity>200</quantity>\n            </order>\n        </orders:submitOrder>\n    </soap:Body>\n</soap:Envelope>";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-bean-service");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrders() throws Exception {
        HTTPMixIn httpMixIn = new HTTPMixIn();
        httpMixIn.initialize();
        try {
            XMLUnit.setIgnoreWhitespace((boolean)true);
            String wsdl = httpMixIn.sendString("http://localhost:8080/quickstart-bean/OrderService?wsdl", "", "GET");
            XMLAssert.assertXMLEqual((Reader)new InputStreamReader(Classes.getResourceAsStream((String)"OrderService.wsdl")), (Reader)new StringReader(wsdl));
            String response = httpMixIn.postString("http://localhost:8080/quickstart-bean/OrderService", SOAP_REQUEST);
            XMLAssert.assertXpathEvaluatesTo((String)"PO-19838-XYZ", (String)"//orderAck/orderId", (String)response);
            XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"//orderAck/accepted", (String)response);
            XMLAssert.assertXpathEvaluatesTo((String)"Order Accepted [intercepted]", (String)"//orderAck/status", (String)response);
        }
        finally {
            httpMixIn.uninitialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGatewayRestart(@ArquillianResource ManagementClient client) throws Exception {
        HTTPMixIn httpMixIn = new HTTPMixIn();
        httpMixIn.initialize();
        try {
            XMLUnit.setIgnoreWhitespace((boolean)true);
            String wsdl = httpMixIn.sendString("http://localhost:8080/quickstart-bean/OrderService?wsdl", "", "GET");
            XMLAssert.assertXMLEqual((Reader)new InputStreamReader(Classes.getResourceAsStream((String)"OrderService.wsdl")), (Reader)new StringReader(wsdl));
            String response = httpMixIn.postString("http://localhost:8080/quickstart-bean/OrderService", SOAP_REQUEST);
            XMLAssert.assertXpathEvaluatesTo((String)"PO-19838-XYZ", (String)"//orderAck/orderId", (String)response);
            XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"//orderAck/accepted", (String)response);
            XMLAssert.assertXpathEvaluatesTo((String)"Order Accepted [intercepted]", (String)"//orderAck/status", (String)response);
            String namespace = "urn:switchyard-quickstart:bean-service:0.1.0";
            String application = "orders";
            String service = "OrderService";
            String bindingType = "soap";
            ModelNode operation = new ModelNode();
            operation.get("address").add("subsystem", "switchyard");
            operation.get("name").set("_OrderService_soap_1");
            operation.get("service-name").set(new QName("urn:switchyard-quickstart:bean-service:0.1.0", "OrderService").toString());
            operation.get("application-name").set(new QName("urn:switchyard-quickstart:bean-service:0.1.0", "orders").toString());
            operation.get("operation").set("stop-gateway");
            ModelNode result = client.getControllerClient().execute(operation);
            Assert.assertEquals((String)("Failed to stop gateway: " + result.toString()), (String)"success", (String)result.get("outcome").asString());
            int status = httpMixIn.sendStringAndGetStatus("http://localhost:8080/quickstart-bean/OrderService", SOAP_REQUEST, "POST");
            Assert.assertEquals((String)"Unexpected status for disabled gateway.", (int)404, (int)status);
            operation.get("operation").set("start-gateway");
            result = client.getControllerClient().execute(operation);
            Assert.assertEquals((String)("Failed to restart gateway" + result.toString()), (String)"success", (String)result.get("outcome").asString());
            wsdl = httpMixIn.sendString("http://localhost:8080/quickstart-bean/OrderService?wsdl", "", "GET");
            XMLAssert.assertXMLEqual((Reader)new InputStreamReader(Classes.getResourceAsStream((String)"OrderService.wsdl")), (Reader)new StringReader(wsdl));
            response = httpMixIn.postString("http://localhost:8080/quickstart-bean/OrderService", SOAP_REQUEST);
            XMLAssert.assertXpathEvaluatesTo((String)"PO-19838-XYZ", (String)"//orderAck/orderId", (String)response);
            XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"//orderAck/accepted", (String)response);
            XMLAssert.assertXpathEvaluatesTo((String)"Order Accepted [intercepted]", (String)"//orderAck/status", (String)response);
        }
        finally {
            httpMixIn.uninitialize();
        }
    }
}

