/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.component.test.mixins.http.HTTPMixIn;
import org.switchyard.test.ArquillianUtil;

@RunWith(value=Arquillian.class)
public class CamelSaxonQuickstartTest {
    private static final String URL = "http://localhost:8080/quickstart-camel-saxon/GreetingService";
    private static final String SOAP_REQUEST = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">   <soapenv:Header/>   <soapenv:Body>      <greet xmlns=\"urn:switchyard-quickstart:camel-saxon:0.1.0\">Garfield</greet>   </soapenv:Body></soapenv:Envelope>";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-camel-saxon");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGreeting() throws Exception {
        HTTPMixIn soapMixIn = new HTTPMixIn();
        soapMixIn.initialize();
        try {
            int status = soapMixIn.sendStringAndGetStatus(URL, SOAP_REQUEST, "POST");
            Assert.assertEquals((String)"Unexpected status.", (int)202, (int)status);
        }
        finally {
            soapMixIn.uninitialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGatewayRestart(@ArquillianResource ManagementClient client) throws Exception {
        HTTPMixIn soapMixIn = new HTTPMixIn();
        soapMixIn.initialize();
        try {
            int status = soapMixIn.sendStringAndGetStatus(URL, SOAP_REQUEST, "POST");
            Assert.assertEquals((String)"Unexpected status.", (int)202, (int)status);
            String namespace = "urn:switchyard-quickstart:camel-saxon:0.1.0";
            String application = "camel-saxon";
            String service = "GreetingService";
            String bindingType = "soap";
            ModelNode operation = new ModelNode();
            operation.get("address").add("subsystem", "switchyard");
            operation.get("name").set("_GreetingService_soap_1");
            operation.get("service-name").set(new QName("urn:switchyard-quickstart:camel-saxon:0.1.0", "GreetingService").toString());
            operation.get("application-name").set(new QName("urn:switchyard-quickstart:camel-saxon:0.1.0", "camel-saxon").toString());
            operation.get("operation").set("stop-gateway");
            ModelNode result = client.getControllerClient().execute(operation);
            Assert.assertEquals((String)("Failed to stop gateway: " + result.toString()), (String)"success", (String)result.get("outcome").asString());
            status = soapMixIn.sendStringAndGetStatus(URL, SOAP_REQUEST, "POST");
            Assert.assertEquals((String)"Unexpected status for disabled gateway.", (int)404, (int)status);
            operation.get("operation").set("start-gateway");
            result = client.getControllerClient().execute(operation);
            Assert.assertEquals((String)("Failed to restart gateway" + result.toString()), (String)"success", (String)result.get("outcome").asString());
            status = soapMixIn.sendStringAndGetStatus(URL, SOAP_REQUEST, "POST");
            Assert.assertEquals((String)"Unexpected status for restarted gateway.", (int)202, (int)status);
        }
        finally {
            soapMixIn.uninitialize();
        }
    }
}

