/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import java.io.IOException;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.Assert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.component.test.mixins.hornetq.HornetQMixIn;
import org.switchyard.test.ArquillianUtil;

@RunWith(value=Arquillian.class)
public class EarDeployQuickstartTest {
    private static final String ORDER_QUEUE_NAME = "EAROrderRequestQueue";
    private static final String ORDERACK_QUEUE_NAME = "EAROrderReplyQueue";
    private static final String REQUEST = "<orders:submitOrder xmlns:orders=\"urn:switchyard-quickstart-demo:multiapp:1.0\"><order><orderId>PO-19838-XYZ</orderId><itemId>BUTTER</itemId><quantity>200</quantity></order></orders:submitOrder>";

    @Deployment(testable=false)
    public static EnterpriseArchive createDeployment() throws IOException {
        return ArquillianUtil.createEarQSDeployment((String)"switchyard-ear-deployment-ear-assembly");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeployment() throws Exception {
        HornetQMixIn hqMixIn = new HornetQMixIn(false).setUser("guest").setPassword("Guestp123!");
        hqMixIn.initialize();
        try {
            Session session = hqMixIn.getJMSSession();
            MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)ORDER_QUEUE_NAME));
            ObjectMessage message = hqMixIn.createJMSMessage(REQUEST);
            producer.send((Message)message);
            MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)ORDERACK_QUEUE_NAME));
            TextMessage reply = (TextMessage)consumer.receive(3000L);
            Assert.assertNotNull((String)"No reply message received from order-consumer", (Object)reply);
            Assert.assertTrue((String)"Received message is not an orderAck", (boolean)reply.getText().contains("orderAck"));
        }
        finally {
            hqMixIn.uninitialize();
        }
    }
}

