/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.jca;

import javax.inject.Inject;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.component.common.label.PropertyLabel;
import org.switchyard.test.jca.JCAJMSFault;
import org.switchyard.test.jca.JCAJMSService;

@Service(value=JCAJMSService.class)
public class JCAJMSServiceImpl
implements JCAJMSService {
    @Inject
    @Reference(value="JCAJMSStoreResult")
    private JCAJMSService _storeResult;
    @Inject
    @Reference(value="JCAJMSStoreFault")
    private JCAJMSService _storeFault;
    @Inject
    private Context _context;
    private int _declaredFaultCount = 0;
    private int _undeclaredFaultCount = 0;

    @Override
    public void onMessage(String name) {
        if (!name.equals("onMessagetest")) {
            throw new RuntimeException("expected content is 'onMessagetest' but was '" + name + "'");
        }
        String val = this._context.getProperty("testProp").getValue().toString();
        if (!val.equals("testVal")) {
            throw new RuntimeException("'testProp' property is '" + val + "' while it should be 'testVal'");
        }
        Property jmsMessageId = this._context.getProperty("javax.jms.JMSMessageID");
        if (jmsMessageId == null) {
            throw new RuntimeException("Couldn't find javax.jms.JMSMessageID context property");
        }
        if (!jmsMessageId.hasLabel(PropertyLabel.HEADER.label())) {
            throw new RuntimeException("javax.jmsJMSMessageID context property doesn't have HEADER label");
        }
        if (jmsMessageId.getValue().toString() == null) {
            throw new RuntimeException("javax.jmsJMSMessageID context property has null value");
        }
        this._storeResult.onMessage(name);
    }

    @Override
    public void onMessage_fault_rollback(String name) {
        this._storeResult.onMessage(name);
        if (this._undeclaredFaultCount < 4) {
            ++this._undeclaredFaultCount;
            this._storeFault.onMessage("faultmessage");
            throw new RuntimeException("faultmessage");
        }
    }

    @Override
    public void onMessage_fault_commit(String name) throws JCAJMSFault {
        this._storeResult.onMessage(name);
        if (this._declaredFaultCount < 4) {
            ++this._declaredFaultCount;
            this._storeFault.onMessage("faultmessage");
            this._context.setProperty("org.switchyard.rollbackOnFault", (Object)false);
            throw new JCAJMSFault("faultmessage");
        }
    }

    @Override
    public String onMessage_inout(String name) {
        return name + "_replyTo";
    }

    @Override
    public String onMessage_inout_fault(String name) throws JCAJMSFault {
        throw new JCAJMSFault(name + "_faultTo");
    }

    @Override
    public String onMessage_inout_context_property(String name) {
        this._context.setProperty("org.switchyard.component.jca.endpoint.replyTo", (Object)"StoreResultQueue", Scope.EXCHANGE);
        this._context.setProperty("org.switchyard.component.jca.endpoint.messageType", (Object)"Bytes", Scope.EXCHANGE);
        return name + "_replyTo";
    }

    @Override
    public String onMessage_inout_physical_name(String name) {
        return name + "_replyTo";
    }

    @Override
    public String onMessage_inout_physical_name_fault(String name) throws JCAJMSFault {
        throw new JCAJMSFault(name + "_faultTo");
    }
}

