/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.jca;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.naming.InitialContext;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.common.type.Classes;
import org.switchyard.component.jca.processor.cci.StreamableRecord;
import org.switchyard.test.jca.JCACCIStreamReference;
import org.switchyard.test.jca.JCACCIStreamReferenceService;
import org.switchyard.test.jca.JCACCIStreamReferenceServiceImpl;
import org.switchyard.test.jca.MyStreamableRecordCCIEndpoint;
import org.switchyard.test.jca.mockra.InteractionListener;
import org.switchyard.test.jca.mockra.MockConnectionFactory;
import org.switchyard.test.jca.mockra.MockResourceAdapter;
import org.switchyard.test.jca.mockra.MockResourceAdapterUtil;

@RunWith(value=Arquillian.class)
public class JCACCIStreamReferenceBindingTest {
    private static final String TEST_CONFIG = "org/switchyard/test/jca/switchyard-outbound-cci-stream-test.xml";
    private static final String DEPLOYMENT_STRUCTURE = "org/switchyard/test/jca/cci-test-app-deployment-structure.xml";
    private static final String APP_NAME = "switchyard-JCACCIStreamReferenceBindingTest.jar";
    private MockResourceAdapter _adapter;
    @ArquillianResource
    InitialContext _context;

    @Deployment(order=1, name="myeis-ra.rar")
    public static ResourceAdapterArchive createResourceAdapter() throws IOException {
        return MockResourceAdapterUtil.createMockResourceAdapterArchive();
    }

    @Deployment(order=2)
    public static JavaArchive createDeployment() throws Exception {
        URL testConfigUrl = Classes.getResource((String)TEST_CONFIG);
        URL deploymentStructureUrl = Classes.getResource((String)DEPLOYMENT_STRUCTURE);
        String beansXml = ((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).exportAsString();
        return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)APP_NAME)).addClass(MyStreamableRecordCCIEndpoint.class)).addClass(JCACCIStreamReference.class)).addClass(JCACCIStreamReferenceService.class)).addClass(JCACCIStreamReferenceServiceImpl.class)).addAsManifestResource((Asset)new UrlAsset(deploymentStructureUrl), "jboss-deployment-structure.xml")).addAsManifestResource((Asset)new UrlAsset(testConfigUrl), "switchyard.xml")).addAsManifestResource((Asset)new StringAsset(beansXml), "beans.xml");
    }

    @Before
    public void before() {
        try {
            MockConnectionFactory factory = (MockConnectionFactory)this._context.lookup("java:jboss/MyEISConnectionFactory");
            factory.setInteractionListener(new InteractionListener(){

                @Override
                public Record onExecute(InteractionSpec spec, Record input) {
                    return null;
                }

                @Override
                public boolean onExecute(InteractionSpec spec, Record input, Record output) {
                    StreamableRecord in = (StreamableRecord)input;
                    StreamableRecord out = (StreamableRecord)output;
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        in.write((OutputStream)baos);
                        String msg = "Hello, " + new String(baos.toByteArray()) + "!";
                        out.read((InputStream)new ByteArrayInputStream(msg.getBytes()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)e.getMessage());
                    }
                    return true;
                }
            });
            this._adapter = (MockResourceAdapter)this._context.lookup("MyEISResourceAdapter");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testOutboundCCI() throws Exception {
        this._adapter.fireCreateEndpoint();
        StreamableRecord input = new StreamableRecord();
        ByteArrayInputStream payload = new ByteArrayInputStream("Antti".getBytes());
        input.read((InputStream)payload);
        Record result = this._adapter.fireDelivery((Record)input);
        this._adapter.fireRelease();
        Assert.assertTrue((boolean)(result instanceof StreamableRecord));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ((StreamableRecord)StreamableRecord.class.cast(result)).write((OutputStream)baos);
        Assert.assertEquals((Object)"Hello, Antti!", (Object)new String(baos.toByteArray()));
    }
}

