/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.jca;

import java.net.URL;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.common.type.Classes;
import org.switchyard.component.test.mixins.hornetq.HornetQMixIn;
import org.switchyard.test.jca.JCAJMSFault;
import org.switchyard.test.jca.JCAJMSReference;
import org.switchyard.test.jca.JCAJMSReferencePhysicalName;
import org.switchyard.test.jca.JCAJMSReferenceService;
import org.switchyard.test.jca.JCAJMSReferenceServiceImpl;
import org.switchyard.test.jca.JCAJMSReferenceText;
import org.switchyard.test.jca.JCAJMSTransactionService;
import org.switchyard.test.jca.JCAJMSTransactionServiceImpl;
import org.switchyard.test.jca.MyJMSContextMapper;
import org.switchyard.test.jca.MyJMSMessageComposer;
import org.switchyard.test.quickstarts.util.ResourceDeployer;

@RunWith(value=Arquillian.class)
public class JCAJMSReferenceBindingTest {
    private static final String TEST_CONFIG = "org/switchyard/test/jca/switchyard-outbound-jms-test.xml";
    private static final String CAMEL_ROUTE = "org/switchyard/test/jca/switchyard-outbound-jms-camel-test-route.xml";
    private static final String JNDI_PROPERTIES = "org/switchyard/test/jca/outbound-jms-jndi.properties";
    private static final String DEST_JNDI_PROPERTIES = "org/switchyard/test/jca/outbound-jms-destination-jndi.properties";
    private static final String INPUT_TX_QUEUE = "TestQueue";
    private static final String INPUT_NOTX_QUEUE = "NonTransactedTestQueue";
    private static final String OUTPUT_QUEUE = "ResultQueue";
    private static final String OUTPUT_PROP_QUEUE = "ResultPropQueue";
    private static final String OUTPUT_PHYSICAL_NAME_QUEUE = "ResultPhysicalNameQueue";
    private Logger _logger = Logger.getLogger(JCAJMSReferenceBindingTest.class);
    private HornetQMixIn _hqMixIn;

    @Deployment(testable=false)
    public static JavaArchive createDeployment() throws Exception {
        ResourceDeployer.addQueue(INPUT_TX_QUEUE);
        ResourceDeployer.addQueue(INPUT_NOTX_QUEUE);
        ResourceDeployer.addQueue(OUTPUT_QUEUE);
        ResourceDeployer.addQueue(OUTPUT_PROP_QUEUE);
        ResourceDeployer.addQueue("ResultPhysicalNameQueue_physical", "ResultPhysicalNameQueue_jndi");
        URL testConfigUrl = Classes.getResource((String)TEST_CONFIG);
        URL camelRouteUrl = Classes.getResource((String)CAMEL_ROUTE);
        URL jndiProperties = Classes.getResource((String)JNDI_PROPERTIES);
        URL destJndiProperties = Classes.getResource((String)DEST_JNDI_PROPERTIES);
        String beansXml = ((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).exportAsString();
        return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"switchyard-JCAJMSReferenceBindingTest.jar")).addClass(JCAJMSTransactionService.class)).addClass(JCAJMSTransactionServiceImpl.class)).addClass(JCAJMSReference.class)).addClass(JCAJMSReferenceText.class)).addClass(JCAJMSReferencePhysicalName.class)).addClass(JCAJMSReferenceService.class)).addClass(JCAJMSReferenceServiceImpl.class)).addClass(JCAJMSFault.class)).addClass(MyJMSContextMapper.class)).addClass(MyJMSMessageComposer.class)).addAsManifestResource((Asset)new UrlAsset(testConfigUrl), "switchyard.xml")).addAsManifestResource((Asset)new StringAsset(beansXml), "beans.xml")).addAsResource((Asset)new UrlAsset(jndiProperties), "jndi.properties")).addAsResource((Asset)new UrlAsset(destJndiProperties), "destination-jndi.properties")).addAsResource((Asset)new UrlAsset(camelRouteUrl), "camel-route.xml");
    }

    @Before
    public void before() {
        this._hqMixIn = new HornetQMixIn(false).setUser("guest").setPassword("Guestp123!");
        this._hqMixIn.initialize();
    }

    @After
    public void after() {
        try {
            this._hqMixIn.uninitialize();
            ResourceDeployer.removeQueue(INPUT_TX_QUEUE);
            ResourceDeployer.removeQueue(INPUT_NOTX_QUEUE);
            ResourceDeployer.removeQueue(OUTPUT_QUEUE);
            ResourceDeployer.removeQueue(OUTPUT_PROP_QUEUE);
            ResourceDeployer.removeQueue("ResultPhysicalNameQueue_physical");
        }
        catch (Exception e) {
            this._logger.warn((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmanagedOutboundJMS() throws Exception {
        String payload = "onMessage";
        Session session = this._hqMixIn.createJMSSession();
        try {
            MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)INPUT_NOTX_QUEUE));
            TextMessage inMsg = session.createTextMessage();
            inMsg.setText(payload);
            producer.send((Message)inMsg);
            producer.close();
            session.close();
            session = this._hqMixIn.createJMSSession();
            MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)OUTPUT_QUEUE));
            Message msg = consumer.receive(3000L);
            consumer.close();
            Assert.assertNotNull((Object)msg);
            Assert.assertTrue((boolean)(msg instanceof ObjectMessage));
            Assert.assertEquals((Object)(payload + "test"), (Object)((ObjectMessage)ObjectMessage.class.cast(msg)).getObject().toString());
            Assert.assertEquals((Object)"testVal", (Object)msg.getStringProperty("testProp"));
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmanagedOutboundJMSSpecifyingMessageType() throws Exception {
        String payload = "onMessageText";
        Session session = this._hqMixIn.createJMSSession();
        try {
            MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)INPUT_NOTX_QUEUE));
            TextMessage inMsg = session.createTextMessage();
            inMsg.setText(payload);
            producer.send((Message)inMsg);
            producer.close();
            session.close();
            session = this._hqMixIn.createJMSSession();
            MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)OUTPUT_QUEUE));
            Message msg = consumer.receive(3000L);
            consumer.close();
            Assert.assertNotNull((Object)msg);
            Assert.assertTrue((boolean)(msg instanceof TextMessage));
            Assert.assertEquals((Object)(payload + "test"), (Object)((TextMessage)TextMessage.class.cast(msg)).getText());
            Assert.assertEquals((Object)"testVal", (Object)msg.getStringProperty("testProp"));
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManagedOutboundJMS() throws Exception {
        String payload = "onMessageManaged";
        Session session = this._hqMixIn.createJMSSession();
        try {
            MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)INPUT_TX_QUEUE));
            TextMessage inMsg = session.createTextMessage();
            inMsg.setText(payload);
            producer.send((Message)inMsg);
            producer.close();
            session.close();
            session = this._hqMixIn.createJMSSession();
            MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)OUTPUT_QUEUE));
            Message msg = consumer.receive(3000L);
            consumer.close();
            Assert.assertNotNull((Object)msg);
            Assert.assertTrue((boolean)(msg instanceof ObjectMessage));
            Assert.assertEquals((Object)(payload + "test"), (Object)((ObjectMessage)ObjectMessage.class.cast(msg)).getObject().toString());
            Assert.assertEquals((Object)"testVal", (Object)msg.getStringProperty("testProp"));
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManagedOutboundJMSSetHeaderFromCamelRoute() throws Exception {
        String payload = "onMessageCamel";
        Session session = this._hqMixIn.createJMSSession();
        try {
            MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)INPUT_TX_QUEUE));
            TextMessage inMsg = session.createTextMessage();
            inMsg.setText(payload);
            producer.send((Message)inMsg);
            producer.close();
            session.close();
            session = this._hqMixIn.createJMSSession();
            MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)OUTPUT_QUEUE));
            Message msg = consumer.receive(3000L);
            consumer.close();
            Assert.assertNotNull((Object)msg);
            Assert.assertTrue((boolean)(msg instanceof ObjectMessage));
            Assert.assertEquals((Object)payload, (Object)((ObjectMessage)ObjectMessage.class.cast(msg)).getObject().toString());
            Assert.assertEquals((Object)"jmscorrelation-onMessageCamel", (Object)msg.getJMSCorrelationID());
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManagedOutboundJMSWithContextProperty() throws Exception {
        String payload = "onMessageContextProperty";
        Session session = this._hqMixIn.createJMSSession();
        try {
            MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)INPUT_TX_QUEUE));
            TextMessage inMsg = session.createTextMessage();
            inMsg.setText(payload);
            producer.send((Message)inMsg);
            producer.close();
            session.close();
            session = this._hqMixIn.createJMSSession();
            MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)OUTPUT_PROP_QUEUE));
            Message msg = consumer.receive(3000L);
            consumer.close();
            Assert.assertNotNull((Object)msg);
            Assert.assertTrue((boolean)(msg instanceof BytesMessage));
            BytesMessage bmsg = (BytesMessage)BytesMessage.class.cast(msg);
            byte[] bytes = new byte[(int)bmsg.getBodyLength()];
            bmsg.readBytes(bytes);
            Assert.assertEquals((Object)(payload + "test"), (Object)new String(bytes));
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManagedOutboundJMSWithPhysicalDestinationName() throws Exception {
        String payload = "onMessagePhysicalName";
        Session session = this._hqMixIn.createJMSSession();
        try {
            MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)INPUT_TX_QUEUE));
            TextMessage inMsg = session.createTextMessage();
            inMsg.setText(payload);
            producer.send((Message)inMsg);
            producer.close();
            session.close();
            session = this._hqMixIn.createJMSSession();
            MessageConsumer consumer = session.createConsumer((Destination)HornetQMixIn.getJMSQueue((String)"ResultPhysicalNameQueue_physical"));
            Message msg = consumer.receive(3000L);
            consumer.close();
            Assert.assertNotNull((Object)msg);
            Assert.assertTrue((boolean)(msg instanceof TextMessage));
            Assert.assertEquals((Object)(payload + "test"), (Object)((TextMessage)TextMessage.class.cast(msg)).getText());
            Assert.assertEquals((Object)"testVal", (Object)msg.getStringProperty("testProp"));
        }
        finally {
            session.close();
        }
    }
}

