/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.jca;

import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.jboss.logging.Logger;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.test.jca.JCAJMSReferenceService;
import org.switchyard.test.jca.JCAJMSTransactionService;

@Service(value=JCAJMSTransactionService.class)
public class JCAJMSTransactionServiceImpl
implements JCAJMSTransactionService {
    private Logger _logger = Logger.getLogger(JCAJMSTransactionServiceImpl.class);
    @Inject
    @Reference
    private JCAJMSReferenceService service;
    @Inject
    @Reference(value="JCAJMSCamelService")
    private JCAJMSReferenceService camelService;

    @Override
    public void onMessage(String name) {
        int txStatus = this.getTransactionStatus();
        if (txStatus != 6) {
            throw new RuntimeException("Unexpected Transaction Status: " + txStatus);
        }
        this.service.onMessage(name);
    }

    @Override
    public void onMessageText(String name) {
        int txStatus = this.getTransactionStatus();
        if (txStatus != 6) {
            throw new RuntimeException("Unexpected Transaction Status: " + txStatus);
        }
        this.service.onMessageText(name);
    }

    @Override
    public void onMessageManaged(String name) {
        int txStatus = this.getTransactionStatus();
        if (txStatus != 0) {
            throw new RuntimeException("Unexpected Transaction Status: " + txStatus);
        }
        this.service.onMessage(name);
    }

    @Override
    public void onMessageCamel(String name) {
        int txStatus = this.getTransactionStatus();
        if (txStatus != 0) {
            throw new RuntimeException("Unexpected Transaction Status: " + txStatus);
        }
        this.camelService.onMessage(name);
    }

    @Override
    public void onMessageContextProperty(String name) throws Exception {
        int txStatus = this.getTransactionStatus();
        if (txStatus != 0) {
            throw new RuntimeException("Unexpected Transaction Status: " + txStatus);
        }
        this.service.onMessageContextProperty(name);
    }

    @Override
    public void onMessagePhysicalName(String name) {
        int txStatus = this.getTransactionStatus();
        if (txStatus != 0) {
            throw new RuntimeException("Unexpected Transaction Status: " + txStatus);
        }
        this.service.onMessagePhysicalName(name);
    }

    private int getTransactionStatus() {
        try {
            InitialContext ic = new InitialContext();
            UserTransaction tx = (UserTransaction)ic.lookup("java:jboss/UserTransaction");
            if (tx != null) {
                return tx.getStatus();
            }
        }
        catch (Exception e) {
            this._logger.warn((Object)e);
        }
        return 6;
    }
}

