/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.hl7.HL7MLLPCodec;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.test.ArquillianUtil;

@RunWith(value=Arquillian.class)
public class CamelHL7QuickstartTest {
    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-camel-hl7");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeployment() throws Exception {
        SimpleRegistry registry = new SimpleRegistry();
        HL7MLLPCodec codec = new HL7MLLPCodec();
        codec.setCharset("iso-8859-1");
        codec.setConvertLFtoCR(true);
        registry.put((Object)"hl7codec", (Object)codec);
        DefaultCamelContext camelContext = null;
        ProducerTemplate template = null;
        try {
            camelContext = new DefaultCamelContext((Registry)registry);
            camelContext.start();
            template = camelContext.createProducerTemplate();
            String line1 = "MSH|^~\\&|MYSENDER|MYRECEIVER|MYAPPLICATION||200612211200||QRY^A19|1234|P|2.4";
            String line2 = "QRD|200612211200|R|I|GetPatient|||1^RD|0101701234|DEM||";
            StringBuilder in = new StringBuilder();
            in.append(line1);
            in.append("\r");
            in.append(line2);
            template.requestBody("mina2:tcp://127.0.0.1:8888?sync=true&codec=#hl7codec", (Object)in.toString());
        }
        finally {
            if (template != null) {
                try {
                    template.stop();
                }
                catch (Exception exception) {}
            }
            if (camelContext != null) {
                try {
                    camelContext.stop();
                }
                catch (Exception exception) {}
            }
        }
    }
}

