/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import java.io.IOException;
import org.custommonkey.xmlunit.XMLAssert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.component.test.mixins.http.HTTPMixIn;
import org.switchyard.test.ArquillianUtil;

@RunWith(value=Arquillian.class)
public class CamelSOAPProxyQuickstartTest {
    private static final String XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\">    <SOAP-ENV:Header/>    <SOAP-ENV:Body>        <ns2:reverse xmlns:ns2=\"urn:switchyard-quickstart:camel-soap-proxy:1.0\">            <text>foobar</text>        </ns2:reverse>    </SOAP-ENV:Body></SOAP-ENV:Envelope>";

    @Deployment(testable=false, order=1, name="ReverseService")
    public static WebArchive createProxyDeployment() throws IOException {
        return ArquillianUtil.createWarQSDeployment((String)"switchyard-camel-soap-proxy-reverse-service");
    }

    @Deployment(testable=false, order=2)
    public static JavaArchive createDeployment() throws IOException {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-camel-soap-proxy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeployment() throws Exception {
        HTTPMixIn soapMixIn = new HTTPMixIn();
        soapMixIn.initialize();
        try {
            String port = System.getProperty("org.switchyard.component.soap.client.port", "8080");
            String dir = System.getProperty("org.switchyard.component.soap.client.dir", "proxy/ReverseService");
            String url = "http://localhost:" + port + "/" + dir;
            String response = soapMixIn.postString(url, XML);
            XMLAssert.assertXpathEvaluatesTo((String)"raboof", (String)"//text", (String)response);
        }
        finally {
            soapMixIn.uninitialize();
        }
    }
}

