/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import javax.xml.namespace.QName;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.quickstarts.remoteinvoker.Application;
import org.switchyard.quickstarts.remoteinvoker.Car;
import org.switchyard.quickstarts.remoteinvoker.Deal;
import org.switchyard.quickstarts.remoteinvoker.Offer;
import org.switchyard.remote.RemoteMessage;
import org.switchyard.remote.http.HttpInvoker;
import org.switchyard.test.ArquillianUtil;

@RunWith(value=Arquillian.class)
public class RemoteInvokerQuickstartTest {
    private static final QName SERVICE = new QName("urn:com.example.switchyard:switchyard-quickstart-remote-invoker:1.0", "Dealer");
    private static final String URL = "http://localhost:8080/switchyard-remote";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-remote-invoker");
    }

    @Test
    public void testOffer() throws Exception {
        HttpInvoker invoker = new HttpInvoker(URL);
        Application app = new Application();
        app.setName("Magesh");
        app.setCreditScore(812);
        Car car = new Car();
        car.setPrice(9600.0);
        Offer offer = new Offer();
        offer.setApplication(app);
        offer.setCar(car);
        offer.setAmount(9000.0);
        RemoteMessage message = new RemoteMessage();
        message.setService(SERVICE).setOperation("offer").setContent((Object)offer);
        RemoteMessage reply = invoker.invoke(message);
        Deal deal = (Deal)reply.getContent();
        Assert.assertTrue((boolean)deal.isAccepted());
    }
}

