/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import javax.xml.namespace.QName;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.component.test.mixins.http.HTTPMixIn;
import org.switchyard.test.ArquillianUtil;
import org.switchyard.test.SwitchYardTestKit;

@RunWith(value=Arquillian.class)
public class RestBindingQuickstartTest {
    private static final String BASE_URL = "http://localhost:8080/rest-binding";
    private static final String SUCCESS = "SUCCESS";
    private static final String ORDER = "<order>    <orderId>1</orderId></order>";
    private static final String ORDER1 = "<order>    <orderId>1</orderId>    <orderItem>        <item>            <itemId>1</itemId>         </item>         <quantity>10</quantity>     </orderItem></order>";
    private static final String ORDER2 = "<order>    <orderId>1</orderId>    <orderItem>        <item>            <itemId>3</itemId>        </item>        <quantity>5</quantity>    </orderItem>    <orderItem>        <item>            <itemId>4</itemId>        </item>        <quantity>3</quantity>    </orderItem></order>";
    private static final String ORDER3 = "<order>    <orderId>1</orderId>    <orderItem>        <item>            <itemId>1</itemId>            <name>Hydrogen Atom - No, we are not kidding!</name>        </item>        <quantity>10</quantity>    </orderItem>    <orderItem>        <item>            <itemId>3</itemId>            <name>Einstein's Bust - Talks about your future :)</name>        </item>        <quantity>5</quantity>    </orderItem>    <orderItem>        <item>            <itemId>4</itemId>            <name>Time Machine</name>        </item>        <quantity>3</quantity>    </orderItem></order>";
    private static final String ORDER4 = "<order>    <orderId>1</orderId>    <orderItem>        <item>            <itemId>3</itemId>            <name>Einstein's Bust - Talks about your future :)</name>        </item>        <quantity>5</quantity>    </orderItem>    <orderItem>        <item>            <itemId>4</itemId>            <name>Time Machine</name>        </item>        <quantity>3</quantity>    </orderItem></order>";
    private static final String ORDER5 = "<order>    <orderId>1</orderId>    <orderItem>        <item>            <itemId>3</itemId>            <name>Theory of relativity</name>        </item>        <quantity>5</quantity>    </orderItem>    <orderItem>        <item>            <itemId>4</itemId>            <name>Coffee Maker</name>        </item>        <quantity>3</quantity>    </orderItem></order>";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-rest-binding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrders(@ArquillianResource ManagementClient client) throws Exception {
        HTTPMixIn httpMixIn = new HTTPMixIn();
        httpMixIn.initialize();
        try {
            String response = httpMixIn.sendString("http://localhost:8080/rest-binding/inventory/create", "", "OPTIONS");
            Assert.assertEquals((Object)SUCCESS, (Object)response);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/order", "", "POST");
            SwitchYardTestKit.compareXMLToString((String)response, (String)ORDER);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/order/item", ORDER1, "PUT");
            Assert.assertEquals((Object)SUCCESS, (Object)response);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/order/item", ORDER2, "PUT");
            Assert.assertEquals((Object)SUCCESS, (Object)response);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/order/1", "", "GET");
            SwitchYardTestKit.compareXMLToString((String)response, (String)ORDER3);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/order/1:1", "", "DELETE");
            Assert.assertEquals((Object)SUCCESS, (Object)response);
            int status = httpMixIn.sendStringAndGetStatus("http://localhost:8080/rest-binding/order/1", "", "DELETE");
            Assert.assertEquals((long)400L, (long)status);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/order/1", "", "GET");
            SwitchYardTestKit.compareXMLToString((String)response, (String)ORDER4);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/inventory/update", "", "OPTIONS");
            Assert.assertEquals((Object)SUCCESS, (Object)response);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/order/1", "", "GET");
            SwitchYardTestKit.compareXMLToString((String)response, (String)ORDER5);
            status = httpMixIn.sendStringAndGetStatus("http://localhost:8080/rest-binding/order/2147483647", "", "GET");
            Assert.assertEquals((long)404L, (long)status);
            status = httpMixIn.sendStringAndGetStatus("http://localhost:8080/rest-binding/warehouse/get/26", "", "GET");
            Assert.assertEquals((long)404L, (long)status);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/inventory/remove", "", "OPTIONS");
            Assert.assertEquals((Object)SUCCESS, (Object)response);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/inventory/create", "", "OPTIONS");
            Assert.assertEquals((Object)SUCCESS, (Object)response);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/order/1", "", "GET");
            SwitchYardTestKit.compareXMLToString((String)response, (String)ORDER4);
            String namespace = "urn:switchyard-quickstart:resteasy-binding:1.0";
            ModelNode operation = new ModelNode();
            operation.get("address").add("subsystem", "switchyard");
            operation.get("name").set("_OrderService_rest_1");
            operation.get("service-name").set(new QName("urn:switchyard-quickstart:resteasy-binding:1.0", "OrderService").toString());
            operation.get("application-name").set(new QName("urn:switchyard-quickstart:resteasy-binding:1.0", "OrderService").toString());
            operation.get("operation").set("stop-gateway");
            ModelNode result = client.getControllerClient().execute(operation);
            Assert.assertEquals((String)("Failed to stop gateway: " + result.toString()), (Object)"success", (Object)result.get("outcome").asString());
            Assert.assertEquals((long)404L, (long)httpMixIn.sendStringAndGetStatus("http://localhost:8080/rest-binding/inventory/update", "", "OPTIONS"));
            operation.get("operation").set("start-gateway");
            result = client.getControllerClient().execute(operation);
            Assert.assertEquals((String)("Failed to restart gateway: " + result.toString()), (Object)"success", (Object)result.get("outcome").asString());
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/order/1", "", "GET");
            SwitchYardTestKit.compareXMLToString((String)response, (String)ORDER4);
            response = httpMixIn.sendString("http://localhost:8080/rest-binding/inventory/remove", "", "OPTIONS");
            Assert.assertEquals((Object)SUCCESS, (Object)response);
        }
        finally {
            httpMixIn.uninitialize();
        }
    }
}

