/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.component.test.mixins.http.HTTPMixIn;
import org.switchyard.test.ArquillianUtil;

@RunWith(value=Arquillian.class)
public class SoapBindingRpcQuickstartTest {
    private static final String SWITCHYARD_WEB_SERVICE = "http://localhost:8080/soap-binding-rpc/HelloWorldWSService";
    private static String REQUEST = "<S:Envelope xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ns2=\"urn:switchyard-quickstart:soap-binding-rpc:1.0\">    <S:Body>        <ns2:sayHello>            <toWhom>SwitchYard</toWhom>            <language>English</language>        </ns2:sayHello>    </S:Body></S:Envelope>";
    private static String REQUEST2 = "<S:Envelope xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ns2=\"urn:switchyard-quickstart:soap-binding-rpc:1.0\">    <S:Body>        <ns2:sayHello>            <toWhom>500</toWhom>            <language>English</language>        </ns2:sayHello>    </S:Body></S:Envelope>";
    private static String RESPONSE = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header/>    <SOAP-ENV:Body>        <ns2:sayHelloResponse xmlns:ns2=\"urn:switchyard-quickstart:soap-binding-rpc:1.0\">            <return>Hello World Greeting for 'SwitchYard' in English on a Sunday!</return>        </ns2:sayHelloResponse>    </SOAP-ENV:Body></SOAP-ENV:Envelope>";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-soap-binding-rpc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void helloWorldService() throws Exception {
        HTTPMixIn httpMixIn = new HTTPMixIn();
        httpMixIn.initialize();
        try {
            XMLUnit.setIgnoreWhitespace((boolean)true);
            String replyMsg = httpMixIn.postString(SWITCHYARD_WEB_SERVICE, REQUEST);
            XMLAssert.assertXMLEqual((String)RESPONSE, (String)replyMsg);
            int status = httpMixIn.sendStringAndGetStatus(SWITCHYARD_WEB_SERVICE, REQUEST2, "POST");
            Assert.assertEquals((long)500L, (long)status);
        }
        finally {
            httpMixIn.uninitialize();
        }
    }
}

