/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPMessage;
import org.custommonkey.xmlunit.XMLAssert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.test.ArquillianUtil;
import org.w3c.dom.Node;

@RunWith(value=Arquillian.class)
public class SoapMtomQuickstartTest {
    private static final String SWITCHYARD_WEB_SERVICE = "http://localhost:8080/soap-mtom/ImageServiceService";
    private static String imageData = "/9j/4AAQSkZJRgABAgAAAQABAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAAQABADASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwDFs0162zJdeLvEepNFcxW0ywahLFDDKTyrsWLlSeAwC5wcHPTRbxbrd3r994UfVbiJA8trDdwXEwkRo8hX3b9zcrzk89z1qjDoXi6W5i1nStG1KC8uI83dnc28iLIQRvB3/LsLYwpbdgAjkcJP4I8S2fjE6yul3osBdi4JaFpZQrNkrtjBLMMkZAxxngVtotjHV77n/9k=";
    private static String RESPONSE = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header/><SOAP-ENV:Body><ns2:imageResponse xmlns:ns2=\"urn:switchyard-quickstart:soap-mtom:1.0\"><xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"cid:internal-resized-switchyard.jpeg\"/></ns2:imageResponse></SOAP-ENV:Body></SOAP-ENV:Envelope>";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-soap-mtom");
    }

    @Test
    public void imageService() throws Exception {
        SOAPMessage response = this.sendMessage();
        XMLAssert.assertXMLEqual((String)RESPONSE, (String)XMLHelper.toString((Node)response.getSOAPPart().getDocumentElement()));
        Assert.assertTrue((boolean)response.getAttachments().hasNext());
        AttachmentPart attachment = (AttachmentPart)response.getAttachments().next();
        Assert.assertNotNull((Object)attachment);
        Assert.assertEquals((Object)"image/jpeg", (Object)attachment.getContentType());
    }

    public SOAPMessage sendMessage() throws Exception {
        SOAPConnectionFactory conFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection connection = conFactory.createConnection();
        MessageFactory msgFactory = MessageFactory.newInstance((String)"SOAP 1.1 Protocol");
        SOAPMessage msg = msgFactory.createMessage();
        SOAPBodyElement bodyElement = msg.getSOAPBody().addBodyElement(new QName("urn:switchyard-quickstart:soap-mtom:1.0", "image"));
        bodyElement.setTextContent(imageData);
        return connection.call(msg, (Object)new URL(SWITCHYARD_WEB_SERVICE));
    }
}

