/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import javax.xml.namespace.QName;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.quickstarts.transform.dozer.Order;
import org.switchyard.quickstarts.transform.dozer.OrderAck;
import org.switchyard.remote.RemoteMessage;
import org.switchyard.remote.http.HttpInvoker;
import org.switchyard.test.ArquillianUtil;

@RunWith(value=Arquillian.class)
public class TransformDozerQuickstartTest {
    private static final QName SERVICE = new QName("urn:switchyard-quickstart:transform-dozer:0.1.0", "OrderService");
    private static final String URL = "http://localhost:8080/switchyard-remote";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-transform-dozer");
    }

    @Test
    public void testDeployment() throws Exception {
        HttpInvoker invoker = new HttpInvoker(URL);
        Order order = new Order();
        order.setItem("Turkey");
        order.setQuantity(1);
        RemoteMessage message = new RemoteMessage();
        message.setService(SERVICE).setOperation("submitOrder").setContent((Object)order);
        RemoteMessage reply = invoker.invoke(message);
        System.out.println(">>>>> " + reply.getContent().toString());
        OrderAck orderAck = (OrderAck)reply.getContent();
        Assert.assertEquals((Object)true, (Object)orderAck.isAccepted());
        Assert.assertEquals((Object)"Order Accepted", (Object)orderAck.getStatusDescription());
        Assert.assertEquals((Object)"PO-19838-XYZ", (Object)orderAck.getOrderId());
    }
}

