/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import javax.xml.namespace.QName;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.quickstarts.transform.json.Order;
import org.switchyard.quickstarts.transform.json.OrderAck;
import org.switchyard.remote.RemoteMessage;
import org.switchyard.remote.http.HttpInvoker;
import org.switchyard.test.ArquillianUtil;

@RunWith(value=Arquillian.class)
public class TransformJsonQuickstartTest {
    private static final QName SERVICE = new QName("urn:switchyard-quickstart:transform-json:0.1.0", "OrderService");

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-transform-json");
    }

    @Test
    public void testDeployment() throws Exception {
        String port = System.getProperty("org.switchyard.component.sca.client.port", "8080");
        HttpInvoker invoker = new HttpInvoker("http://localhost:" + port + "/switchyard-remote");
        Order order = new Order();
        order.setItemId("Turkey");
        order.setOrderId("Xmas Dinner");
        order.setQuantity(1);
        RemoteMessage message = new RemoteMessage();
        message.setService(SERVICE).setOperation("submitOrder").setContent((Object)order);
        RemoteMessage reply = invoker.invoke(message);
        Assert.assertFalse((boolean)reply.isFault());
        OrderAck orderAck = (OrderAck)reply.getContent();
        Assert.assertTrue((boolean)orderAck.isAccepted());
    }
}

