/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts.demo;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.zip.ZipFile;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.custommonkey.xmlunit.XMLAssert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.picketlink.identity.federation.api.wstrust.WSTrustClient;
import org.switchyard.common.io.pull.StringPuller;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.test.mixins.http.HTTPMixIn;
import org.switchyard.test.ArquillianUtil;
import org.switchyard.test.quickstarts.util.ResourceDeployer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@RunWith(value=Arquillian.class)
@ServerSetup(value={SSLSocketBindingSetupTask.class})
public class PolicySecuritySamlDemoQuickstartTest {
    private static String SRC_DIR = System.getProperty("jboss.home") + "/quickstarts/switchyard/demos/policy-security-saml";

    @Deployment(testable=false, order=1, name="picketlink-sts")
    public static WebArchive createPicketlinkSTSWar() throws Exception {
        File artifactFile = new File(SRC_DIR, "picketlink-sts.war");
        if (!artifactFile.isFile()) {
            Assert.fail((String)("Failed to resolve artifact '" + artifactFile + "'.  The artifact must be declared as a dependency in your POM, thereby making it available in your local repository."));
        }
        return (WebArchive)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)artifactFile.getName())).importFrom(new ZipFile(artifactFile)).as(WebArchive.class);
    }

    @Deployment(testable=false, order=2)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarDemoDeployment((String)"switchyard-demo-policy-security-saml");
    }

    @Test
    public void testUnsecure() throws Exception {
        String response = this.invokeWorkService("http", 8080, "policy-security-saml", null, null);
        Assert.assertTrue((boolean)response.toLowerCase().contains("fault"));
    }

    @Test
    public void testConfidentialSecure() throws Exception {
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(new FileInputStream(new File(SRC_DIR, "connector.jks")), "changeit".toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(keystore);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keystore, "changeit".toCharArray());
        SSLContext sslcontext = SSLContext.getInstance("TLS");
        sslcontext.init(keyManagerFactory.getKeyManagers(), tmf.getTrustManagers(), null);
        String response = this.invokeWorkService("https", 8443, "policy-security-saml", this.getAssertion(), sslcontext);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"//received", (String)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String invokeWorkService(String scheme, int port, String context, Element assertion, SSLContext sslContext) throws Exception {
        String soapRequest = ((String)new StringPuller().pull(new File(SRC_DIR, "src/test/resources/xml/soap-request.xml"))).replaceAll("WORK_CMD", "CMD-" + System.currentTimeMillis());
        if (assertion != null) {
            soapRequest = soapRequest.replaceFirst("<!-- Assertion -->", XMLHelper.toString((Node)assertion));
        }
        HTTPMixIn http = new HTTPMixIn(sslContext);
        http.initialize();
        try {
            String endpoint = String.format("%s://localhost:%s/%s/WorkService", scheme, port, context);
            String string = http.postString(endpoint, soapRequest);
            return string;
        }
        finally {
            http.uninitialize();
        }
    }

    private Element getAssertion() throws Exception {
        WSTrustClient client = new WSTrustClient("PicketLinkSTS", "PicketLinkSTSPort", "http://localhost:8080/picketlink-sts/PicketLinkSTS", new WSTrustClient.SecurityInfo("admin", "admin"));
        return client.issueToken("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
    }

    public static class SSLSocketBindingSetupTask
    implements ServerSetupTask {
        public void setup(ManagementClient client, String unused) throws Exception {
            ResourceDeployer.setupSSL(client, new File(SRC_DIR, "connector.jks").getAbsolutePath(), "changeit");
            ModelNode op = new ModelNode();
            op.get("operation").set("add");
            op.get("address").add("subsystem", "security");
            op.get("address").add("security-domain", "picketlink-sts");
            op.get("cache-type").set("default");
            client.getControllerClient().execute(op);
            ModelNode loginModule = new ModelNode();
            loginModule.get("code").set("UsersRoles");
            loginModule.get("flag").set("required");
            loginModule.get("module-options").add("usersProperties", "users.properties");
            loginModule.get("module-options").add("rolesProperties", "roles.properties");
            op = new ModelNode();
            op.get("operation").set("add");
            op.get("address").add("subsystem", "security");
            op.get("address").add("security-domain", "picketlink-sts");
            op.get("address").add("authentication", "classic");
            op.get("login-modules").add(loginModule);
            op.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set("true");
            client.getControllerClient().execute(op);
            op = new ModelNode();
            op.get("operation").set("add");
            op.get("address").add("subsystem", "security");
            op.get("address").add("security-domain", "saml-validate-token");
            op.get("cache-type").set("default");
            client.getControllerClient().execute(op);
            loginModule = new ModelNode();
            loginModule.get("code").set("org.picketlink.identity.federation.core.wstrust.auth.STSValidatingLoginModule");
            loginModule.get("flag").set("required");
            loginModule.get("module-options").add("configFile", new File(SRC_DIR, "sts-client.properties").getAbsolutePath());
            loginModule.get("module-options").add("useOptionsCredentials", true);
            op = new ModelNode();
            op.get("operation").set("add");
            op.get("address").add("subsystem", "security");
            op.get("address").add("security-domain", "saml-validate-token");
            op.get("address").add("authentication", "classic");
            op.get("login-modules").add(loginModule);
            op.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set("true");
            client.getControllerClient().execute(op);
            Thread.sleep(1000L);
        }

        public void tearDown(ManagementClient client, String unused) throws Exception {
            ResourceDeployer.tearDownSSL(client);
            ModelNode op = new ModelNode();
            op.get("operation").set("remove");
            op.get("address").add("subsystem", "security");
            op.get("address").add("security-domain", "picketlink-sts");
            client.getControllerClient().execute(op);
            op = new ModelNode();
            op.get("operation").set("remove");
            op.get("address").add("subsystem", "security");
            op.get("address").add("security-domain", "saml-validate-token");
            client.getControllerClient().execute(op);
        }
    }
}

