/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts.demo;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.custommonkey.xmlunit.XMLAssert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.common.io.pull.StringPuller;
import org.switchyard.component.test.mixins.http.HTTPMixIn;
import org.switchyard.test.ArquillianUtil;
import org.switchyard.test.quickstarts.util.ResourceDeployer;

@RunWith(value=Arquillian.class)
@ServerSetup(value={SSLSocketBindingSetupTask.class})
public class PolicySecurityWssUsernameDemoQuickstartTest {
    private static String SRC_DIR = System.getProperty("jboss.home") + "/quickstarts/switchyard/demos/policy-security-wss-username";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        return ArquillianUtil.createJarDemoDeployment((String)"switchyard-demo-policy-security-wss-username");
    }

    @Test
    public void testConfidentialAuthentication() throws Exception {
        String response = this.invokeWorkService("https", 8443, "policy-security-wss-username", "kermit", this.setupSSLContext());
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"//received", (String)response);
    }

    @Test
    public void testConfidentialAuthenticationFail() throws Exception {
        String response = this.invokeWorkService("https", 8443, "policy-security-wss-username", "misspiggy", this.setupSSLContext());
        XMLAssert.assertXpathExists((String)"//faultcode", (String)response);
    }

    @Test
    public void testAuthentication() throws Exception {
        String response = this.invokeWorkService("http", 8080, "policy-security-wss-username", "kermit", null);
        XMLAssert.assertXpathExists((String)"//faultcode", (String)response);
    }

    @Test
    public void testAuthenticationFail() throws Exception {
        String response = this.invokeWorkService("http", 8080, "policy-security-wss-username", "misspiggy", null);
        XMLAssert.assertXpathExists((String)"//faultcode", (String)response);
    }

    private SSLContext setupSSLContext() throws Exception {
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(new FileInputStream(new File(SRC_DIR, "connector.jks")), "changeit".toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(keystore);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keystore, "changeit".toCharArray());
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), tmf.getTrustManagers(), null);
        return sslContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String invokeWorkService(String scheme, int port, String context, String username, SSLContext sslContext) throws Exception {
        String soapRequest = ((String)new StringPuller().pull(new File(SRC_DIR, "src/test/resources/xml/soap-request.xml"))).replaceAll("WORK_CMD", "CMD-" + System.currentTimeMillis());
        HTTPMixIn http = new HTTPMixIn(sslContext);
        soapRequest = soapRequest.replaceFirst("<!-- Username -->", username);
        http.initialize();
        try {
            String endpoint = String.format("%s://localhost:%s/%s/WorkService", scheme, port, context);
            String string = http.postString(endpoint, soapRequest);
            return string;
        }
        finally {
            http.uninitialize();
        }
    }

    public static class SSLSocketBindingSetupTask
    implements ServerSetupTask {
        public void setup(ManagementClient client, String unused) throws Exception {
            ResourceDeployer.setupSSL(client, new File(SRC_DIR, "connector.jks").getAbsolutePath(), "changeit");
            Thread.sleep(1000L);
        }

        public void tearDown(ManagementClient client, String unused) throws Exception {
            ResourceDeployer.tearDownSSL(client);
        }
    }
}

