/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.quickstarts;

import java.io.IOException;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.xml.namespace.QName;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.switchyard.component.test.mixins.hornetq.HornetQMixIn;
import org.switchyard.test.ArquillianUtil;
import org.switchyard.test.quickstarts.util.ResourceDeployer;

@RunWith(value=Arquillian.class)
public class CamelJMSBindingQuickstartTest {
    private static final String QUEUE = "GreetingServiceQueue";

    @Deployment(testable=false)
    public static JavaArchive createDeployment() throws IOException {
        ResourceDeployer.addQueue(QUEUE);
        return ArquillianUtil.createJarQSDeployment((String)"switchyard-camel-jms-binding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeployment() throws Exception {
        HornetQMixIn hqMixIn = new HornetQMixIn(false).setUser("guest").setPassword("Guestp123!");
        hqMixIn.initialize();
        try {
            Session session = hqMixIn.getJMSSession();
            MessageProducer producer = session.createProducer((Destination)HornetQMixIn.getJMSQueue((String)QUEUE));
            ObjectMessage message = hqMixIn.createJMSMessage("Tomo");
            producer.send((Message)message);
        }
        finally {
            hqMixIn.uninitialize();
            ResourceDeployer.removeQueue(QUEUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGatewayRestart(@ArquillianResource ManagementClient client) throws Exception {
        HornetQMixIn hqMixIn = new HornetQMixIn(false).setUser("guest").setPassword("Guestp123!");
        hqMixIn.initialize();
        try {
            Session session = hqMixIn.getJMSSession();
            Queue queue = HornetQMixIn.getJMSQueue((String)QUEUE);
            MessageProducer producer = session.createProducer((Destination)queue);
            QueueBrowser browser = session.createBrowser(queue);
            ObjectMessage message = hqMixIn.createJMSMessage("Restarter");
            producer.send((Message)message);
            Thread.sleep(1000L);
            Assert.assertFalse((boolean)browser.getEnumeration().hasMoreElements());
            String namespace = "urn:switchyard-quickstart:camel-jms-binding:0.1.0";
            String application = "camel-jms-binding";
            String service = "GreetingService";
            String bindingType = "jms";
            ModelNode operation = new ModelNode();
            operation.get("address").add("subsystem", "switchyard");
            operation.get("name").set("_GreetingService_jms_1");
            operation.get("service-name").set(new QName("urn:switchyard-quickstart:camel-jms-binding:0.1.0", "GreetingService").toString());
            operation.get("application-name").set(new QName("urn:switchyard-quickstart:camel-jms-binding:0.1.0", "camel-jms-binding").toString());
            operation.get("operation").set("stop-gateway");
            ModelNode result = client.getControllerClient().execute(operation);
            Assert.assertEquals((String)("Failed to stop gateway: " + result.toString()), (Object)"success", (Object)result.get("outcome").asString());
            message = hqMixIn.createJMSMessage("Stopped");
            producer.send((Message)message);
            Thread.sleep(1000L);
            Assert.assertEquals((Object)message.getJMSMessageID(), (Object)((Message)browser.getEnumeration().nextElement()).getJMSMessageID());
            operation.get("operation").set("start-gateway");
            result = client.getControllerClient().execute(operation);
            Assert.assertEquals((String)("Failed to restart gateway" + result.toString()), (Object)"success", (Object)result.get("outcome").asString());
            message = hqMixIn.createJMSMessage("Restarted");
            producer.send((Message)message);
            Thread.sleep(1000L);
            Assert.assertFalse((boolean)browser.getEnumeration().hasMoreElements());
        }
        finally {
            hqMixIn.uninitialize();
            ResourceDeployer.removeQueue(QUEUE);
        }
    }
}

