/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.log4j.Logger;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.bus.camel.ExchangeDispatcher;
import org.switchyard.bus.camel.audit.AuditInterceptStrategy;
import org.switchyard.bus.camel.audit.FaultInterceptStrategy;
import org.switchyard.bus.camel.processors.Processors;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.internal.ExchangeImpl;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.spi.Dispatcher;
import org.switchyard.spi.ExchangeBus;

public class CamelExchangeBus
implements ExchangeBus {
    private static final Predicate IN_OUT_CHECK = new Predicate(){

        public boolean matches(Exchange exchange) {
            ExchangeImpl syEx = (ExchangeImpl)exchange.getProperty("SwitchYardExchange", ExchangeImpl.class);
            ServiceOperation operation = syEx.getContract().getConsumerOperation();
            return operation.getExchangePattern() == ExchangePattern.IN_OUT;
        }

        public String toString() {
            return "IN_OUT_CHECK";
        }
    };
    private Logger _logger = Logger.getLogger(CamelExchangeBus.class);
    private HashMap<QName, ExchangeDispatcher> _dispatchers = new HashMap();
    private SwitchYardCamelContext _camelContext;

    public CamelExchangeBus(SwitchYardCamelContext context) {
        this._camelContext = context;
    }

    public void init(ServiceDomain domain) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)("Initialization of CamelExchangeBus for domain " + domain.getName()));
        }
        SimpleRegistry registry = this._camelContext.getWritebleRegistry();
        for (Processors processor : Processors.values()) {
            registry.put((Object)processor.name(), (Object)processor.create(domain));
        }
    }

    public synchronized void start() {
        try {
            this._camelContext.start();
        }
        catch (Exception ex) {
            throw new SwitchYardException("Failed to start Camel Exchange Bus", (Throwable)ex);
        }
    }

    public synchronized void stop() {
        try {
            this._dispatchers.clear();
            this._camelContext.stop();
        }
        catch (Exception ex) {
            throw new SwitchYardException("Failed to stop Camel Exchange Bus", (Throwable)ex);
        }
    }

    public Dispatcher getDispatcher(ServiceReference reference) {
        return this._dispatchers.get(reference.getName());
    }

    public Dispatcher createDispatcher(ServiceReference reference) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)("Creating Camel dispatcher for " + reference.getName()));
        }
        final String endpoint = "direct:" + reference.getName();
        RouteBuilder rb = new RouteBuilder(){

            public void configure() throws Exception {
                RouteDefinition definition = this.from(endpoint);
                definition.routeId(endpoint);
                definition.addInterceptStrategy((InterceptStrategy)new FaultInterceptStrategy());
                definition.addInterceptStrategy((InterceptStrategy)new AuditInterceptStrategy());
                Map interceptStrategies = CamelExchangeBus.this._camelContext.getRegistry().lookupByType(InterceptStrategy.class);
                if (interceptStrategies != null) {
                    for (Map.Entry interceptEntry : interceptStrategies.entrySet()) {
                        if (CamelExchangeBus.this._logger.isDebugEnabled()) {
                            CamelExchangeBus.this._logger.debug((Object)("Adding intercept strategy " + (String)interceptEntry.getKey() + " to route " + endpoint));
                        }
                        definition.addInterceptStrategy((InterceptStrategy)interceptEntry.getValue());
                    }
                }
                ExpressionNode filterDefinition = (ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)new FilterDefinition(IN_OUT_CHECK).processRef(Processors.DOMAIN_HANDLERS.name())).processRef(Processors.VALIDATION.name())).processRef(Processors.TRANSFORMATION.name())).processRef(Processors.VALIDATION.name())).processRef(Processors.CONSUMER_CALLBACK.name());
                OnExceptionDefinition onException = new OnExceptionDefinition(HandlerException.class);
                onException.handled(true);
                onException.addOutput((ProcessorDefinition)filterDefinition);
                definition.addOutput((ProcessorDefinition)onException);
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)definition.processRef(Processors.DOMAIN_HANDLERS.name())).processRef(Processors.ADDRESSING.name())).processRef(Processors.TRANSACTION_HANDLER.name())).processRef(Processors.SECURITY.name())).processRef(Processors.GENERIC_POLICY.name())).processRef(Processors.VALIDATION.name())).processRef(Processors.TRANSFORMATION.name())).processRef(Processors.VALIDATION.name())).processRef(Processors.PROVIDER_CALLBACK.name())).processRef(Processors.TRANSACTION_HANDLER.name())).addOutput((ProcessorDefinition)filterDefinition);
            }
        };
        try {
            if (this._camelContext.getRoute(endpoint) != null) {
                this._camelContext.removeRoute(endpoint);
                if (this._logger.isInfoEnabled()) {
                    this._logger.info((Object)("Removing route " + endpoint));
                }
            }
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("Created route for " + endpoint + ", definition is: " + rb.toString()));
            }
            this._camelContext.addRoutes((RoutesBuilder)rb);
        }
        catch (Exception ex) {
            throw new SwitchYardException("Failed to create Camel route for service " + reference.getName(), (Throwable)ex);
        }
        ExchangeDispatcher dispatcher = new ExchangeDispatcher(reference, this._camelContext.createProducerTemplate());
        this._dispatchers.put(reference.getName(), dispatcher);
        return dispatcher;
    }
}

