/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel.processors;

import java.util.Arrays;
import java.util.List;
import org.apache.camel.Processor;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangeState;

public class HandlerProcessor
implements Processor {
    private Logger _logger = Logger.getLogger(HandlerProcessor.class);
    private List<ExchangeHandler> _handlers;

    public HandlerProcessor(ExchangeHandler handler) {
        this(Arrays.asList(handler));
    }

    public HandlerProcessor(List<ExchangeHandler> handlers) {
        this._handlers = handlers;
    }

    public void process(org.apache.camel.Exchange ex) throws Exception {
        Exchange exchange = (Exchange)ex.getProperty("SwitchYardExchange", Exchange.class);
        for (ExchangeHandler handler : this._handlers) {
            if (exchange.getState() == ExchangeState.FAULT) {
                try {
                    handler.handleFault(exchange);
                }
                catch (Exception e) {
                    this._logger.error((Object)"Unexpected exception thrown during handling FAULT response", (Throwable)e);
                }
                continue;
            }
            handler.handleMessage(exchange);
        }
    }

    public String toString() {
        return "HandlerProcessor [" + this._handlers + "]";
    }
}

