/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.log4j.Logger;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.bus.camel.CamelExchangeBusRouteBuilder;
import org.switchyard.bus.camel.ExchangeDispatcher;
import org.switchyard.bus.camel.processors.Processors;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.spi.Dispatcher;
import org.switchyard.spi.ExchangeBus;

public class CamelExchangeBus
implements ExchangeBus {
    private Logger _logger = Logger.getLogger(CamelExchangeBus.class);
    private HashMap<QName, ExchangeDispatcher> _dispatchers = new HashMap();
    private SwitchYardCamelContext _camelContext;

    public CamelExchangeBus(SwitchYardCamelContext context) {
        this._camelContext = context;
    }

    public void init(ServiceDomain domain) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)("Initialization of CamelExchangeBus for domain " + domain.getName()));
        }
        SimpleRegistry registry = this._camelContext.getWritebleRegistry();
        for (Processors processor : Processors.values()) {
            registry.put((Object)processor.name(), (Object)processor.create(domain));
        }
    }

    public synchronized void start() {
        try {
            this._camelContext.start();
        }
        catch (Exception ex) {
            throw new SwitchYardException("Failed to start Camel Exchange Bus", (Throwable)ex);
        }
    }

    public synchronized void stop() {
        try {
            this._dispatchers.clear();
            this._camelContext.stop();
        }
        catch (Exception ex) {
            throw new SwitchYardException("Failed to stop Camel Exchange Bus", (Throwable)ex);
        }
    }

    public Dispatcher getDispatcher(ServiceReference reference) {
        return this._dispatchers.get(reference.getName());
    }

    public Dispatcher createDispatcher(ServiceReference reference) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)("Creating Camel dispatcher for " + reference.getName()));
        }
        String endpoint = "direct:" + reference.getName();
        CamelExchangeBusRouteBuilder rb = new CamelExchangeBusRouteBuilder(endpoint);
        try {
            if (this._camelContext.getRoute(endpoint) != null) {
                this._camelContext.removeRoute(endpoint);
                if (this._logger.isInfoEnabled()) {
                    this._logger.info((Object)("Removing route " + endpoint));
                }
            }
            if (this._logger.isDebugEnabled()) {
                this._logger.debug((Object)("Created route for " + endpoint + ", definition is: " + rb.toString()));
            }
            this._camelContext.addRoutes((RoutesBuilder)rb);
        }
        catch (Exception ex) {
            throw new SwitchYardException("Failed to create Camel route for service " + reference.getName(), (Throwable)ex);
        }
        ExchangeDispatcher dispatcher = new ExchangeDispatcher(reference, this._camelContext.createProducerTemplate());
        this._dispatchers.put(reference.getName(), dispatcher);
        return dispatcher;
    }
}

