/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel.audit;

import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.log4j.Logger;
import org.switchyard.bus.camel.audit.AfterProcessor;
import org.switchyard.bus.camel.audit.Audit;
import org.switchyard.bus.camel.audit.Auditor;
import org.switchyard.bus.camel.audit.BeforeProcessor;
import org.switchyard.bus.camel.audit.CompositeAuditor;
import org.switchyard.bus.camel.processors.Processors;

public class AuditInterceptStrategy
implements InterceptStrategy {
    private Logger _logger = Logger.getLogger(AuditInterceptStrategy.class);

    public Processor wrapProcessorInInterceptors(CamelContext context, ProcessorDefinition<?> definition, Processor target, Processor nextTarget) throws Exception {
        if (!(definition instanceof ProcessDefinition)) {
            if (this._logger.isTraceEnabled()) {
                this._logger.trace((Object)("Ignore " + definition + " as it's not intent to be handled with custom auditors"));
            }
            return target;
        }
        ProcessDefinition process = (ProcessDefinition)definition;
        Map auditors = context.getRegistry().lookupByType(Auditor.class);
        if (auditors != null) {
            ArrayList<Auditor> wrappers = new ArrayList<Auditor>();
            for (Map.Entry entry : auditors.entrySet()) {
                if (!this.matches((Auditor)entry.getValue(), process)) continue;
                if (this._logger.isTraceEnabled()) {
                    this._logger.trace((Object)("Found matching auditor " + (String)entry.getKey() + " for processing step " + process.getRef()));
                }
                wrappers.add((Auditor)entry.getValue());
            }
            if (wrappers.size() > 0) {
                ArrayList<Processor> processors = new ArrayList<Processor>();
                CompositeAuditor auditor = new CompositeAuditor(wrappers);
                Processors step = Processors.valueOf(process.getRef());
                processors.add(new BeforeProcessor(step, auditor));
                processors.add(target);
                processors.add(new AfterProcessor(step, auditor));
                return new Pipeline(context, processors);
            }
        }
        if (this._logger.isTraceEnabled()) {
            this._logger.trace((Object)"No custom or matching auditors were found, using original processors");
        }
        return target;
    }

    private boolean matches(Auditor auditor, ProcessDefinition process) {
        Audit annotation = auditor.getClass().getAnnotation(Audit.class);
        if (annotation == null || annotation.value().length == 0) {
            return true;
        }
        String ref = process.getRef();
        for (Processors processor : annotation.value()) {
            if (!processor.name().equals(ref)) continue;
            return true;
        }
        return false;
    }
}

