/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel;

import java.util.Map;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.LoggingErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.InterceptStrategy;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.bus.camel.CamelExchangeBus;
import org.switchyard.bus.camel.CamelHelper;
import org.switchyard.bus.camel.audit.AuditInterceptStrategy;
import org.switchyard.bus.camel.audit.FaultInterceptStrategy;
import org.switchyard.bus.camel.processors.Processors;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.ServiceOperation;

public class CamelExchangeBusRouteBuilder
extends RouteBuilder {
    private static final Predicate IN_OUT_CHECK = new Predicate(){

        public boolean matches(org.apache.camel.Exchange exchange) {
            Exchange syEx = CamelHelper.getSwitchYardExchange(exchange);
            ServiceOperation operation = syEx.getContract().getConsumerOperation();
            return operation.getExchangePattern() == ExchangePattern.IN_OUT;
        }

        public String toString() {
            return "IN_OUT_CHECK";
        }
    };
    private String _endpoint;

    public CamelExchangeBusRouteBuilder(String endpoint) {
        this._endpoint = endpoint;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure() throws Exception {
        RouteDefinition definition = this.from(this._endpoint);
        definition.routeId(this._endpoint);
        Map handlers = this.getContext().getRegistry().lookupByType(ErrorHandlerBuilder.class);
        if (handlers != null && !handlers.isEmpty()) {
            if (handlers.size() != 1) throw new SwitchYardException("Only one exception handler can be defined. Found " + handlers.keySet());
            definition.errorHandler((ErrorHandlerFactory)handlers.values().iterator().next());
        } else {
            LoggingErrorHandlerBuilder errorHandler = this.loggingErrorHandler(CamelExchangeBus.class.getName());
            errorHandler.setLevel(LoggingLevel.DEBUG);
            definition.errorHandler((ErrorHandlerFactory)errorHandler);
        }
        definition.addInterceptStrategy((InterceptStrategy)new FaultInterceptStrategy());
        definition.addInterceptStrategy((InterceptStrategy)new AuditInterceptStrategy());
        Map interceptStrategies = this.getContext().getRegistry().lookupByType(InterceptStrategy.class);
        if (interceptStrategies != null) {
            for (Map.Entry interceptEntry : interceptStrategies.entrySet()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Adding intercept strategy {} to route {}", interceptEntry.getKey(), (Object)this._endpoint);
                }
                definition.addInterceptStrategy((InterceptStrategy)interceptEntry.getValue());
            }
        }
        ExpressionNode filterDefinition = (ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)new FilterDefinition(IN_OUT_CHECK).processRef(Processors.DOMAIN_HANDLERS.name())).processRef(Processors.VALIDATION.name())).processRef(Processors.TRANSFORMATION.name())).processRef(Processors.VALIDATION.name())).processRef(Processors.CONSUMER_CALLBACK.name());
        OnExceptionDefinition onException = new OnExceptionDefinition(Throwable.class);
        onException.handled(true);
        onException.addOutput((ProcessorDefinition)filterDefinition);
        definition.addOutput((ProcessorDefinition)onException);
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)definition.processRef(Processors.DOMAIN_HANDLERS.name())).processRef(Processors.ADDRESSING.name())).processRef(Processors.TRANSACTION_HANDLER.name())).processRef(Processors.SECURITY.name())).processRef(Processors.GENERIC_POLICY.name())).processRef(Processors.VALIDATION.name())).processRef(Processors.TRANSFORMATION.name())).processRef(Processors.VALIDATION.name())).processRef(Processors.PROVIDER_CALLBACK.name())).processRef(Processors.TRANSACTION_HANDLER.name())).addOutput((ProcessorDefinition)filterDefinition);
    }
}

