/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel;

import java.util.HashSet;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.bus.camel.CamelExchangeProperty;
import org.switchyard.bus.camel.CamelMessageProperty;

public class CamelCompositeContext
implements Context {
    private final Exchange _exchange;
    private final Message _message;

    public CamelCompositeContext(Exchange exchange) {
        this(exchange, exchange.getIn());
    }

    public CamelCompositeContext(Exchange exchange, Message message) {
        this._exchange = exchange;
        this._message = message;
    }

    public Context copy() {
        return new CamelCompositeContext(this._exchange);
    }

    public Property getProperty(String name) {
        Property property = this.getProperty(name, Scope.MESSAGE);
        return property == null ? this.getProperty(name, Scope.EXCHANGE) : property;
    }

    public Property getProperty(String name, Scope scope) {
        switch (scope) {
            case EXCHANGE: {
                return this.getExchangeProperty(name);
            }
        }
        return this.getMessageProperty(name);
    }

    private Property getMessageProperty(String name) {
        if (this._message.hasHeaders() && this._message.getHeaders().containsKey(name)) {
            return new CamelMessageProperty(this._message, name);
        }
        return null;
    }

    private Property getExchangeProperty(String name) {
        if (this._exchange.hasProperties() && this._exchange.getProperties().containsKey(name)) {
            return new CamelExchangeProperty(this._exchange, name);
        }
        return null;
    }

    public <T> T getPropertyValue(String name) {
        Property property = this.getProperty(name);
        return (T)(property == null ? null : property.getValue());
    }

    public Set<Property> getProperties() {
        HashSet<Property> properties = new HashSet<Property>();
        properties.addAll(this.getProperties(Scope.EXCHANGE));
        properties.addAll(this.getProperties(Scope.MESSAGE));
        return properties;
    }

    public Set<Property> getProperties(Scope scope) {
        HashSet<Property> properties = new HashSet<Property>();
        switch (scope) {
            case EXCHANGE: {
                if (!this._exchange.hasProperties()) break;
                for (String prop : this._exchange.getProperties().keySet()) {
                    properties.add(new CamelExchangeProperty(this._exchange, prop));
                }
                break;
            }
            default: {
                if (!this._message.hasHeaders()) break;
                for (String prop : this._message.getHeaders().keySet()) {
                    properties.add(new CamelMessageProperty(this._message, prop));
                }
            }
        }
        return properties;
    }

    public Set<Property> getProperties(String label) {
        HashSet<Property> properties = new HashSet<Property>();
        for (Property property : this.getProperties()) {
            if (!property.hasLabel(label)) continue;
            properties.add(property);
        }
        return properties;
    }

    public void removeProperty(Property property) {
        switch (property.getScope()) {
            case EXCHANGE: {
                this._exchange.removeProperty(property.getName());
                break;
            }
            default: {
                this._message.removeHeader(property.getName());
            }
        }
    }

    public void removeProperties() {
        for (Property property : this.getProperties()) {
            this.removeProperty(property);
        }
    }

    public void removeProperties(Scope scope) {
        for (Property property : this.getProperties(scope)) {
            this.removeProperty(property);
        }
    }

    public void removeProperties(String label) {
        for (Property property : this.getProperties()) {
            if (!property.hasLabel(label)) continue;
            this.removeProperty(property);
        }
    }

    public Property setProperty(String name, Object val) {
        return this.setProperty(name, val, Scope.MESSAGE);
    }

    public Property setProperty(String name, Object val, Scope scope) {
        switch (scope) {
            case EXCHANGE: {
                this._exchange.setProperty(name, val);
                break;
            }
            default: {
                this._message.setHeader(name, val);
            }
        }
        return this.getProperty(name, scope);
    }

    public Context setProperties(Set<Property> properties) {
        for (Property property : properties) {
            Set labels = property.getLabels();
            this.setProperty(property.getName(), property.getValue(), property.getScope()).addLabels(labels.toArray(new String[labels.size()]));
        }
        return this;
    }
}

