/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel;

import java.util.Collections;
import java.util.Map;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.spi.InterceptStrategy;
import org.switchyard.ExchangePattern;
import org.switchyard.bus.camel.CamelExchange;
import org.switchyard.bus.camel.DefaultErrorListener;
import org.switchyard.bus.camel.ErrorListener;
import org.switchyard.bus.camel.audit.AuditInterceptStrategy;
import org.switchyard.bus.camel.audit.FaultInterceptStrategy;
import org.switchyard.bus.camel.processors.Processors;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.ServiceOperation;

public class CamelExchangeBusRouteBuilder
extends RouteBuilder {
    private static final Predicate IN_OUT_CHECK = new Predicate(){

        public boolean matches(Exchange exchange) {
            ServiceOperation operation = new CamelExchange(exchange).getContract().getConsumerOperation();
            return operation.getExchangePattern() == ExchangePattern.IN_OUT;
        }

        public String toString() {
            return "IN_OUT_CHECK";
        }
    };
    private String _endpoint;

    public CamelExchangeBusRouteBuilder(String endpoint) {
        this._endpoint = endpoint;
    }

    public SwitchYardCamelContext getContext() {
        return (SwitchYardCamelContext)super.getContext();
    }

    public void configure() throws Exception {
        RouteDefinition definition = this.from(this._endpoint);
        definition.routeId(this._endpoint);
        Map<String, ErrorHandlerBuilder> handlers = this.lookup(ErrorHandlerBuilder.class);
        if (handlers.isEmpty()) {
            definition.errorHandler((ErrorHandlerFactory)this.loggingErrorHandler());
        } else if (handlers.size() == 1) {
            definition.errorHandler((ErrorHandlerFactory)handlers.values().iterator().next());
        } else {
            throw new SwitchYardException("Only one exception handler can be defined. Found " + handlers.keySet());
        }
        definition.addInterceptStrategy((InterceptStrategy)new FaultInterceptStrategy());
        definition.addInterceptStrategy((InterceptStrategy)new AuditInterceptStrategy());
        for (Map.Entry<String, InterceptStrategy> interceptEntry : this.lookup(InterceptStrategy.class).entrySet()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding intercept strategy {} to route {}", (Object)interceptEntry.getKey(), (Object)this._endpoint);
            }
            definition.addInterceptStrategy(interceptEntry.getValue());
        }
        Map<String, ErrorListener> errorListeners = this.lookup(ErrorListener.class);
        if (errorListeners.isEmpty()) {
            this.getContext().getWritebleRegistry().put((Object)"defaultErrorListener", (Object)new DefaultErrorListener());
        }
        TryDefinition tryDefinition = definition.doTry();
        ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)tryDefinition.processRef(Processors.DOMAIN_HANDLERS.name())).processRef(Processors.ADDRESSING.name())).processRef(Processors.TRANSACTION_HANDLER.name())).processRef(Processors.SECURITY.name())).processRef(Processors.GENERIC_POLICY.name())).processRef(Processors.VALIDATION.name())).processRef(Processors.TRANSFORMATION.name())).processRef(Processors.VALIDATION.name())).processRef(Processors.PROVIDER_CALLBACK.name())).processRef(Processors.TRANSACTION_HANDLER.name())).addOutput((ProcessorDefinition)this.createFilterDefinition());
        ((TryDefinition)((TryDefinition)tryDefinition.doCatch(Exception.class).processRef(Processors.ERROR_HANDLING.name())).processRef(Processors.TRANSACTION_HANDLER.name())).addOutput((ProcessorDefinition)this.createFilterDefinition());
    }

    private ExpressionNode createFilterDefinition() {
        return (ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)new FilterDefinition(IN_OUT_CHECK).processRef(Processors.DOMAIN_HANDLERS.name())).processRef(Processors.VALIDATION.name())).processRef(Processors.TRANSFORMATION.name())).processRef(Processors.VALIDATION.name())).processRef(Processors.SECURITY.name())).processRef(Processors.CONSUMER_CALLBACK.name());
    }

    private <T> Map<String, T> lookup(Class<T> type) {
        Map result = this.getContext().getRegistry().lookupByType(type);
        if (result == null) {
            return Collections.emptyMap();
        }
        return result;
    }
}

