/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel;

import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.switchyard.Context;
import org.switchyard.Message;
import org.switchyard.bus.camel.CamelCompositeContext;
import org.switchyard.common.camel.HandlerDataSource;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.common.camel.SwitchYardMessage;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;

public class CamelMessage
extends SwitchYardMessage
implements Message {
    public CamelMessage(Exchange exchange) {
        this.setExchange(exchange);
    }

    public Message setContent(Object content) {
        this.setBody(content);
        return this;
    }

    public Object getContent() {
        return this.getBody();
    }

    public <T> T getContent(Class<T> type) {
        return (T)this.getBody(type);
    }

    protected <T> T getBody(Class<T> type, Object body) {
        if (type == null) {
            throw new IllegalArgumentException("null 'type' argument.");
        }
        if (body == null) {
            return null;
        }
        if (type.isInstance(body)) {
            return type.cast(body);
        }
        TransformerRegistry transformerRegistry = this.getTransformerRegistry();
        if (transformerRegistry == null) {
            throw new SwitchYardException("Cannot convert from '" + body.getClass().getName() + "' to '" + type.getName() + "'.  No TransformRegistry available.");
        }
        QName toType = JavaService.toMessageType(type);
        QName fromType = JavaService.toMessageType(body.getClass());
        Transformer transformer = transformerRegistry.getTransformer(fromType, toType);
        if (transformer == null) {
            Object camelBody = super.getBody(type, body);
            if (camelBody == null) {
                throw new SwitchYardException("Cannot convert from '" + body.getClass().getName() + "' to '" + type.getName() + "'.  No registered Transformer available for transforming from '" + fromType + "' to '" + toType + "'.  A Transformer must be registered.");
            }
            return (T)camelBody;
        }
        Object transformedContent = transformer.transform(body);
        if (transformedContent == null) {
            throw new SwitchYardException("Error converting from '" + body.getClass().getName() + "' to '" + type.getName() + "'.  Transformer '" + transformer.getClass().getName() + "' returned null.");
        }
        if (!type.isInstance(transformedContent)) {
            throw new SwitchYardException("Error converting from '" + body.getClass().getName() + "' to '" + type.getName() + "'.  Transformer '" + transformer.getClass().getName() + "' returned incompatible type '" + transformedContent.getClass().getName() + "'.");
        }
        return type.cast(transformedContent);
    }

    public Message addAttachment(String name, DataSource attachment) {
        this.addAttachment(name, new DataHandler(attachment));
        return this;
    }

    public HandlerDataSource getAttachment(String name) {
        DataHandler attachement = super.getAttachment(name);
        return attachement != null ? new HandlerDataSource(attachement) : null;
    }

    public void removeAttachment(String name) {
        HandlerDataSource attachment = this.getAttachment(name);
        if (attachment != null) {
            this.removeAttachment(name);
        }
    }

    public Map<String, DataSource> getAttachmentMap() {
        HashMap<String, DataSource> attachements = new HashMap<String, DataSource>();
        for (Map.Entry attachement : this.getAttachments().entrySet()) {
            attachements.put((String)attachement.getKey(), ((DataHandler)attachement.getValue()).getDataSource());
        }
        return attachements;
    }

    public Context getContext() {
        return new CamelCompositeContext(this.getExchange(), (org.apache.camel.Message)this);
    }

    public CamelMessage copy() {
        CamelMessage message = this.newInstance();
        message.setBody(this.getBody());
        return message;
    }

    public CamelMessage newInstance() {
        return new CamelMessage(this.getExchange());
    }

    public void sent() {
        this.getContext().setProperty("org.switchyard.bus.camel.messageSent", (Object)true).addLabels(new String[]{BehaviorLabel.TRANSIENT.name()});
    }

    public boolean isSent() {
        return (Boolean)this.getHeader("org.switchyard.bus.camel.messageSent", false, Boolean.class);
    }

    private TransformerRegistry getTransformerRegistry() {
        CamelContext context = this.getExchange().getContext();
        if (context instanceof SwitchYardCamelContext) {
            return ((SwitchYardCamelContext)context).getServiceDomain().getTransformerRegistry();
        }
        return null;
    }
}

