/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel;

import org.apache.camel.CamelContext;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.model.ModelCamelContext;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.ServiceReference;
import org.switchyard.bus.camel.CamelExchange;
import org.switchyard.bus.camel.CamelMessage;
import org.switchyard.spi.Dispatcher;

public class ExchangeDispatcher
implements Dispatcher {
    private final ModelCamelContext _context;
    private ServiceReference _reference;
    private ProducerTemplate _producer;

    public ExchangeDispatcher(ModelCamelContext context, ServiceReference reference) {
        this._context = context;
        this._reference = reference;
        this._producer = context.createProducerTemplate();
    }

    public ServiceReference getServiceReference() {
        return this._reference;
    }

    public Exchange createExchange(ExchangeHandler replyHandler, ExchangePattern pattern) {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this._context, this.translate(pattern));
        exchange.setIn((Message)new CamelMessage((org.apache.camel.Exchange)exchange));
        return new CamelExchange(this, (org.apache.camel.Exchange)exchange, replyHandler);
    }

    private org.apache.camel.ExchangePattern translate(ExchangePattern pattern) {
        return ExchangePattern.IN_OUT == pattern ? org.apache.camel.ExchangePattern.InOut : org.apache.camel.ExchangePattern.InOnly;
    }

    public void dispatch(Exchange exchange) {
        if (exchange instanceof CamelExchange) {
            if (exchange.getPhase().equals((Object)ExchangePhase.IN)) {
                this._producer.send("direct:" + exchange.getConsumer().getName(), ((CamelExchange)exchange).getExchange());
            }
        } else {
            throw new IllegalArgumentException("Camel Bus accepts only CamelExchanges");
        }
    }
}

