/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel.audit;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.log4j.Logger;
import org.switchyard.bus.camel.CamelExchange;

public class FaultProcessor
extends DelegateAsyncProcessor {
    private Logger _logger = Logger.getLogger(FaultProcessor.class);

    public FaultProcessor(Processor target) {
        super(target);
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        return super.process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (doneSync && CamelExchange.isFault(exchange) && exchange.getException() != null) {
                    FaultProcessor.this.handle(exchange.getException(), exchange);
                    exchange.setException(null);
                }
                callback.done(doneSync);
            }
        });
    }

    protected void handle(Throwable throwable, Exchange exchange) {
        this._logger.error((Object)"Unexpected exception thrown during handling FAULT response. This exception can not be handled, thus it's marked as handled and only logged. If you don't want see messages like this consider handling exceptions in your handler logic", throwable);
    }

    public String toString() {
        return "FaultProcessor [" + this.getProcessor() + "]";
    }
}

