/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel;

import org.apache.log4j.Logger;
import org.switchyard.ErrorListener;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.common.lang.Strings;
import org.switchyard.runtime.util.ExchangeFormatter;

public class DefaultErrorListener
implements ErrorListener {
    private static final Logger LOG = Logger.getLogger(DefaultErrorListener.class);

    public void notify(Exchange exchange, Throwable throwable) {
        ExchangePattern pattern = exchange.getContract().getConsumerOperation().getExchangePattern();
        String message = String.format("%s\nCaught exception of type %s with message: %s", ExchangeFormatter.format((Exchange)exchange, (boolean)false), throwable.getClass().getName(), throwable.getMessage());
        String causeTrace = "";
        if (throwable.getCause() != null) {
            String causedBy = "\n%sCaused by exception of type %s, message: %s";
            int depth = 0;
            for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
                causeTrace = causeTrace + String.format(causedBy, Strings.repeat((String)"  ", (int)(++depth)), cause.getClass().getName(), cause.getMessage());
            }
        }
        if (pattern == ExchangePattern.IN_ONLY) {
            LOG.error((Object)(message + causeTrace), throwable);
        } else {
            LOG.debug((Object)(message + causeTrace), throwable);
        }
    }
}

