/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.camel;

import java.io.InputStream;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.spring.CamelContextFactoryBean;
import org.apache.camel.spring.SpringModelJAXBContextFactory;
import org.switchyard.SwitchYardException;
import org.switchyard.common.camel.CamelContextFactoryBeanDelegate;
import org.switchyard.common.camel.CommonCamelLogger;
import org.switchyard.common.camel.CommonCamelMessages;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.common.type.Classes;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class CamelModelFactory {
    private static final String NS_SPRING = "http://www.springframework.org/schema/beans";
    private static final String NS_CAMEL_SPRING = "http://camel.apache.org/schema/spring";
    private static JAXBContext JAXB_CONTEXT;

    private CamelModelFactory() {
    }

    public static Object createCamelModelObjectFromXML(String xmlPath) throws Exception {
        InputStream input = Classes.getResourceAsStream((String)xmlPath);
        if (input == null) {
            throw CommonCamelMessages.MESSAGES.specifiedCamelContextFileIsNotFound(xmlPath);
        }
        InputSource source = new InputSource(input);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(source);
        Element element = document.getDocumentElement();
        Element camelModelElement = CamelModelFactory.findCamelModelElement(element, xmlPath);
        if (camelModelElement == null) {
            throw CommonCamelMessages.MESSAGES.noCamelContextElementFound(xmlPath);
        }
        Binder binder = JAXB_CONTEXT.createBinder();
        Object obj = binder.unmarshal((Object)camelModelElement);
        CamelModelFactory.injectNamespaces(camelModelElement, (Binder<Node>)binder);
        return obj;
    }

    private static Element findCamelModelElement(Element top, String xmlPath) {
        if (top.getNamespaceURI().equals(NS_SPRING) && top.getNodeName().equals("beans")) {
            Element camelContext = null;
            NodeList list = top.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                if (element.getNamespaceURI().equals(NS_CAMEL_SPRING) && element.getNodeName().equals("camelContext")) {
                    if (camelContext == null) {
                        camelContext = element;
                        continue;
                    }
                    CommonCamelLogger.ROOT_LOGGER.ignoringMultipleCamelContextElement(xmlPath);
                    continue;
                }
                CommonCamelLogger.ROOT_LOGGER.ignoringUnsupportedElement(xmlPath, new QName(element.getNamespaceURI(), element.getNodeName()));
            }
            return camelContext != null ? camelContext : null;
        }
        return top;
    }

    private static void injectNamespaces(Element element, Binder<Node> binder) {
        NodeList list = element.getChildNodes();
        Namespaces namespaces = null;
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node child = list.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            Object object = binder.getJAXBNode((Object)child);
            if (object instanceof NamespaceAware) {
                NamespaceAware namespaceAware = (NamespaceAware)object;
                if (namespaces == null) {
                    namespaces = new Namespaces(element);
                }
                namespaces.configure(namespaceAware);
            }
            CamelModelFactory.injectNamespaces(childElement, binder);
        }
    }

    public static void importCamelContextFactoryBean(SwitchYardCamelContext context, CamelContextFactoryBean bean) throws Exception {
        new CamelContextFactoryBeanDelegate(context, bean).importConfiguration();
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((String)"org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer:org.apache.camel.model.rest:org.apache.camel.core.xml:org.apache.camel.spring:org.apache.camel.util.spring:", (ClassLoader)SpringModelJAXBContextFactory.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new SwitchYardException((Throwable)e);
        }
    }
}

