/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.camel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.CompositeRegistry;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.Registry;
import org.switchyard.ServiceDomain;
import org.switchyard.common.camel.CamelContextConfigurator;
import org.switchyard.common.camel.CdiBeanRegistry;
import org.switchyard.common.camel.CdiInjector;
import org.switchyard.common.camel.CommonCamelLogger;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.common.camel.event.CamelEventBridge;
import org.switchyard.common.cdi.CDIUtil;

public class SwitchYardCamelContextImpl
extends DefaultCamelContext
implements SwitchYardCamelContext {
    private final SimpleRegistry _writeableRegistry = new SimpleRegistry();
    private ServiceDomain _domain;
    private AtomicInteger _count = new AtomicInteger();
    private static final int DEFAULT_TIMEOUT = 30;
    private boolean _cdiIntegration;

    public SwitchYardCamelContextImpl() {
        this(true);
    }

    public SwitchYardCamelContextImpl(boolean autoDetectCdi) {
        this._cdiIntegration = autoDetectCdi;
        if (this.isEnableCdiIntegration()) {
            CDISupport.setCdiInjector(this);
        } else {
            CommonCamelLogger.ROOT_LOGGER.cdiNotDetected();
        }
        this.getManagementStrategy().addEventNotifier((EventNotifier)new CamelEventBridge());
    }

    public void setServiceDomain(ServiceDomain domain) {
        this._domain = domain;
        for (EventNotifier notifier : this.getManagementStrategy().getEventNotifiers()) {
            if (!(notifier instanceof CamelEventBridge)) continue;
            ((CamelEventBridge)notifier).setEventPublisher(domain.getEventPublisher());
        }
        PackageScanClassResolver packageScanClassResolver = this.findPackageScanClassResolver();
        if (packageScanClassResolver != null) {
            this.setPackageScanClassResolver(packageScanClassResolver);
        }
        this._domain.setProperty("CamelContextProperty", (Object)this);
    }

    @Override
    public SimpleRegistry getWritebleRegistry() {
        return this._writeableRegistry;
    }

    public PackageScanClassResolver findPackageScanClassResolver() {
        ServiceLoader<PackageScanClassResolver> resolverLoaders = ServiceLoader.load(PackageScanClassResolver.class);
        Iterator<PackageScanClassResolver> iterator = resolverLoaders.iterator();
        if (iterator.hasNext()) {
            PackageScanClassResolver packageScanClassResolver = iterator.next();
            return packageScanClassResolver;
        }
        return null;
    }

    protected CompositeRegistry createRegistry() {
        ServiceLoader<Registry> registriesLoaders = ServiceLoader.load(Registry.class, this.getClass().getClassLoader());
        ArrayList<Object> registries = new ArrayList<Object>();
        registries.add(new JndiRegistry());
        if (this.isEnableCdiIntegration()) {
            BeanManager bm = CDIUtil.lookupBeanManager();
            registries.add(new CdiBeanRegistry(bm));
        }
        registries.add(this._writeableRegistry);
        for (Registry registry : registriesLoaders) {
            registries.add(registry);
        }
        return new CompositeRegistry(registries);
    }

    @Override
    public ServiceDomain getServiceDomain() {
        return this._domain;
    }

    public boolean isEnableCdiIntegration() {
        if (!this._cdiIntegration) {
            return false;
        }
        return CDISupport.isCDIEnabled();
    }

    public void start() throws Exception {
        if (this._count.incrementAndGet() == 1) {
            this.applyConfiguration();
            super.start();
        }
    }

    public void stop() throws Exception {
        if (this._count.decrementAndGet() == 0) {
            super.stop();
        }
    }

    private void applyConfiguration() {
        if (this._domain == null || this._domain.getProperties() == null) {
            return;
        }
        this.getShutdownStrategy().setTimeout(30L);
        CamelContextConfigurator.configure((CamelContext)this, this._domain);
    }

    static class CDISupport {
        CDISupport() {
        }

        static boolean isCDIEnabled() {
            try {
                return CDIUtil.lookupBeanManager() != null;
            }
            catch (NoClassDefFoundError e) {
                return false;
            }
        }

        static void addCdiRegistry(List<Registry> registries) {
            BeanManager bm = CDIUtil.lookupBeanManager();
            registries.add(new CdiBeanRegistry(bm));
        }

        public static void setCdiInjector(SwitchYardCamelContextImpl context) {
            BeanManager bm = CDIUtil.lookupBeanManager();
            context.setInjector(new CdiInjector(context.getInjector(), bm));
        }
    }
}

