/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.camel;

import java.util.Iterator;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.core.xml.AbstractCamelContextFactoryBean;
import org.apache.camel.core.xml.CamelJMXAgentDefinition;
import org.apache.camel.core.xml.CamelPropertyPlaceholderDefinition;
import org.apache.camel.core.xml.CamelStreamCachingStrategyDefinition;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ContextScanDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PackageScanDefinition;
import org.apache.camel.model.PropertiesDefinition;
import org.apache.camel.model.RestContextRefDefinition;
import org.apache.camel.model.RouteBuilderDefinition;
import org.apache.camel.model.RouteContextRefDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ThreadPoolProfileDefinition;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spring.CamelContextFactoryBean;
import org.apache.camel.spring.CamelEndpointFactoryBean;
import org.apache.camel.spring.CamelRedeliveryPolicyFactoryBean;
import org.jboss.logging.Logger;
import org.switchyard.common.camel.SwitchYardCamelContext;

public class CamelContextFactoryBeanDelegate
extends AbstractCamelContextFactoryBean<SwitchYardCamelContext> {
    private static final Logger LOG = Logger.getLogger(CamelContextFactoryBeanDelegate.class);
    private CamelContextFactoryBean _factoryBean;
    private SwitchYardCamelContext _camelContext;

    public CamelContextFactoryBeanDelegate(SwitchYardCamelContext context, CamelContextFactoryBean bean) {
        this._camelContext = context;
        this._factoryBean = bean;
        String id = bean.getId();
        if (id != null && context instanceof DefaultCamelContext) {
            ((DefaultCamelContext)context).setName(id);
        } else {
            id = context.getName();
        }
        this.setId(id);
    }

    public void importConfiguration() throws Exception {
        Endpoint created;
        this.afterPropertiesSet();
        if (this._factoryBean.getEndpoints() != null) {
            for (CamelEndpointFactoryBean endpoint : this._factoryBean.getEndpoints()) {
                endpoint.setCamelContext((CamelContext)this._camelContext);
                endpoint.afterPropertiesSet();
                created = endpoint.getObject();
                this._camelContext.getWritebleRegistry().put((Object)endpoint.getId(), (Object)created);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Registered camel endpoint '" + endpoint.getId() + "'"));
            }
        }
        if (this._factoryBean.getRedeliveryPolicies() != null) {
            for (CamelRedeliveryPolicyFactoryBean policy : this._factoryBean.getRedeliveryPolicies()) {
                policy.setCamelContext((CamelContext)this._camelContext);
                policy.afterPropertiesSet();
                created = policy.getObject();
                this._camelContext.getWritebleRegistry().put((Object)policy.getId(), (Object)created);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Registered camel RedeliveryPolicy '" + policy.getId() + "'"));
            }
        }
        this.setupRoutes();
    }

    public void setRoutes(List<RouteDefinition> routes) {
        this._factoryBean.setRoutes(routes);
    }

    public void setRests(List<RestDefinition> rests) {
        this._factoryBean.setRests(rests);
    }

    public Class<SwitchYardCamelContext> getObjectType() {
        return SwitchYardCamelContext.class;
    }

    public SwitchYardCamelContext getContext(boolean create) {
        return this._camelContext;
    }

    public void setContext(SwitchYardCamelContext context) {
        this._camelContext = context;
    }

    public List<RouteDefinition> getRoutes() {
        return this._factoryBean.getRoutes();
    }

    public List<RestDefinition> getRests() {
        return this._factoryBean.getRests();
    }

    public RestConfigurationDefinition getRestConfiguration() {
        return this._factoryBean.getRestConfiguration();
    }

    public List<CamelEndpointFactoryBean> getEndpoints() {
        return this._factoryBean.getEndpoints();
    }

    public List<CamelRedeliveryPolicyFactoryBean> getRedeliveryPolicies() {
        return this._factoryBean.getRedeliveryPolicies();
    }

    public List<InterceptDefinition> getIntercepts() {
        return this._factoryBean.getIntercepts();
    }

    public List<InterceptFromDefinition> getInterceptFroms() {
        return this._factoryBean.getInterceptFroms();
    }

    public List<InterceptSendToEndpointDefinition> getInterceptSendToEndpoints() {
        return this._factoryBean.getInterceptSendToEndpoints();
    }

    public PropertiesDefinition getProperties() {
        return this._factoryBean.getProperties();
    }

    public String[] getPackages() {
        return this._factoryBean.getPackages();
    }

    public PackageScanDefinition getPackageScan() {
        return this._factoryBean.getPackageScan();
    }

    public void setPackageScan(PackageScanDefinition packageScan) {
        this._factoryBean.setPackageScan(packageScan);
    }

    public ContextScanDefinition getContextScan() {
        return this._factoryBean.getContextScan();
    }

    public void setContextScan(ContextScanDefinition contextScan) {
        this._factoryBean.setContextScan(contextScan);
    }

    public CamelPropertyPlaceholderDefinition getCamelPropertyPlaceholder() {
        return this._factoryBean.getCamelPropertyPlaceholder();
    }

    public String getTrace() {
        return this._factoryBean.getTrace();
    }

    public String getMessageHistory() {
        return this._factoryBean.getMessageHistory();
    }

    public String getStreamCache() {
        return this._factoryBean.getStreamCache();
    }

    public String getDelayer() {
        return this._factoryBean.getDelayer();
    }

    public String getHandleFault() {
        return this._factoryBean.getHandleFault();
    }

    public String getAutoStartup() {
        return this._factoryBean.getAutoStartup();
    }

    public String getUseMDCLogging() {
        return this._factoryBean.getUseMDCLogging();
    }

    public String getUseBreadcrumb() {
        return this._factoryBean.getUseBreadcrumb();
    }

    public String getAllowUseOriginalMessage() {
        return this._factoryBean.getAllowUseOriginalMessage();
    }

    public String getRuntimeEndpointRegistryEnabled() {
        return this._factoryBean.getRuntimeEndpointRegistryEnabled();
    }

    public String getManagementNamePattern() {
        return this._factoryBean.getManagementNamePattern();
    }

    public String getThreadNamePattern() {
        return this._factoryBean.getThreadNamePattern();
    }

    @Deprecated
    public Boolean getLazyLoadTypeConverters() {
        return this._factoryBean.getLazyLoadTypeConverters();
    }

    public Boolean getTypeConverterStatisticsEnabled() {
        return this._factoryBean.getTypeConverterStatisticsEnabled();
    }

    public CamelJMXAgentDefinition getCamelJMXAgent() {
        return this._factoryBean.getCamelJMXAgent();
    }

    public CamelStreamCachingStrategyDefinition getCamelStreamCachingStrategy() {
        return this._factoryBean.getCamelStreamCachingStrategy();
    }

    public List<RouteBuilderDefinition> getBuilderRefs() {
        return this._factoryBean.getBuilderRefs();
    }

    public List<RouteContextRefDefinition> getRouteRefs() {
        return this._factoryBean.getRouteRefs();
    }

    public List<RestContextRefDefinition> getRestRefs() {
        return this._factoryBean.getRestRefs();
    }

    public String getErrorHandlerRef() {
        return this._factoryBean.getErrorHandlerRef();
    }

    public DataFormatsDefinition getDataFormats() {
        return this._factoryBean.getDataFormats();
    }

    public List<OnExceptionDefinition> getOnExceptions() {
        return this._factoryBean.getOnExceptions();
    }

    public List<OnCompletionDefinition> getOnCompletions() {
        return this._factoryBean.getOnCompletions();
    }

    public ShutdownRoute getShutdownRoute() {
        return this._factoryBean.getShutdownRoute();
    }

    public ShutdownRunningTask getShutdownRunningTask() {
        return this._factoryBean.getShutdownRunningTask();
    }

    public List<ThreadPoolProfileDefinition> getThreadPoolProfiles() {
        return this._factoryBean.getThreadPoolProfiles();
    }

    public String getDependsOn() {
        return this._factoryBean.getDependsOn();
    }

    protected <S> S getBeanForType(Class<S> clazz) {
        Iterator iterator = this._camelContext.getRegistry().findByType(clazz).iterator();
        return iterator.hasNext() ? (S)iterator.next() : null;
    }

    protected void findRouteBuildersByPackageScan(String[] packages, PackageScanFilter filter, List<RoutesBuilder> builders) throws Exception {
    }

    protected void findRouteBuildersByContextScan(PackageScanFilter filter, List<RoutesBuilder> builders) throws Exception {
    }

    protected void initCustomRegistry(SwitchYardCamelContext context) {
    }

    protected void initBeanPostProcessor(SwitchYardCamelContext context) {
    }

    protected void postProcessBeforeInit(RouteBuilder builder) {
    }
}

