/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.cdi;

import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Named;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;

public final class CDIUtil {
    private CDIUtil() {
    }

    public static BeanManager lookupBeanManager() {
        try {
            BeanManagerProvider provider = BeanManagerProvider.getInstance();
            if (provider != null) {
                return provider.getBeanManager();
            }
            return null;
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public static Object lookupBean(String name) {
        BeanManager manager = CDIUtil.lookupBeanManager();
        Set beans = manager.getBeans(name);
        if (beans != null && !beans.isEmpty()) {
            Bean bean = (Bean)beans.iterator().next();
            CreationalContext context = manager.createCreationalContext((Contextual)bean);
            return manager.getReference(bean, Object.class, context);
        }
        return null;
    }

    public static String getNamedAnnotationValue(Class<?> clazz) {
        Named named = clazz.getAnnotation(Named.class);
        if (named == null) {
            return null;
        }
        return named.value();
    }
}

