/* 
 * JBoss, Home of Professional Open Source 
 * Copyright 2011 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @author tags. All rights reserved. 
 * See the copyright.txt in the distribution for a 
 * full listing of individual contributors.
 *
 * This copyrighted material is made available to anyone wishing to use, 
 * modify, copy, or redistribute it subject to the terms and conditions 
 * of the GNU Lesser General Public License, v. 2.1. 
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details. 
 * You should have received a copy of the GNU Lesser General Public License, 
 * v.2.1 along with this distribution; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 */
package org.switchyard.common.io.resource;

import java.net.URL;

/**
 * Represents a resource.
 *
 * @author David Ward &lt;<a href="mailto:dward@jboss.org">dward@jboss.org</a>&gt; (C) 2011 Red Hat Inc.
 */
public interface Resource {

    /**
     * Gets the location of the resource.
     * @return the location of the resource
     */
    public String getLocation();

    /**
     * Gets the URL form of the resource's location.
     * @return the URL form of the resource's location
     */
    public URL getLocationURL();

    /**
     * Gets the URL form of the resource's location.
     * @param caller the caller class so we can check with it's classloader
     * @return the URL form of the resource's location
     */
    public URL getLocationURL(Class<?> caller);

    /**
     * Gets the URL form of the resource's location.
     * @param loader the classloader to check with
     * @return the URL form of the resource's location
     */
    public URL getLocationURL(ClassLoader loader);

    /**
     * Gets the type of the resource.
     * @return the type of the resource
     */
    public ResourceType getType();

}
