/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.version;

import org.switchyard.common.version.Query;
import org.switchyard.common.version.QueryType;

public final class Queries {
    private Queries() {
    }

    public static final class Projects {
        public static final Query SWITCHYARD = new Query(QueryType.PROJECT_GROUP_ID, "org.switchyard");
        public static final Query[] SWITCHYARD_ADMIN = Projects.create(SWITCHYARD, "switchyard-admin");
        public static final Query[] SWITCHYARD_API = Projects.create(SWITCHYARD, "switchyard-api");
        public static final Query[] SWITCHYARD_COMMON = Projects.create(SWITCHYARD, "switchyard-common");
        public static final Query[] SWITCHYARD_COMPONENT_BEAN = Projects.create(SWITCHYARD, "switchyard-component-bean");
        public static final Query[] SWITCHYARD_COMPONENT_BPEL = Projects.create(SWITCHYARD, "switchyard-component-bpel");
        public static final Query[] SWITCHYARD_COMPONENT_BPM = Projects.create(SWITCHYARD, "switchyard-component-bpm");
        public static final Query[] SWITCHYARD_COMPONENT_CAMEL = Projects.create(SWITCHYARD, "switchyard-component-camel");
        public static final Query[] SWITCHYARD_COMPONENT_CLOJURE = Projects.create(SWITCHYARD, "switchyard-component-clojure");
        public static final Query[] SWITCHYARD_COMPONENT_COMMON_RULES = Projects.create(SWITCHYARD, "switchyard-component-common-rules");
        public static final Query[] SWITCHYARD_COMPONENT_HORNETQ = Projects.create(SWITCHYARD, "switchyard-component-hornetq");
        public static final Query[] SWITCHYARD_COMPONENT_RULES = Projects.create(SWITCHYARD, "switchyard-component-rules");
        public static final Query[] SWITCHYARD_COMPONENT_SOAP = Projects.create(SWITCHYARD, "switchyard-component-soap");
        public static final Query[] SWITCHYARD_CONFIG = Projects.create(SWITCHYARD, "switchyard-config");
        public static final Query[] SWITCHYARD_RUNTIME = Projects.create(SWITCHYARD, "switchyard-runtime");
        public static final Query[] SWITCHYARD_TRANSFORM = Projects.create(SWITCHYARD, "switchyard-transform");
        public static final Query[] SWITCHYARD_VALIDATE = Projects.create(SWITCHYARD, "switchyard-validate");

        private Projects() {
        }

        public static Query[] create(String groupId, String artifactId) {
            return Projects.create(new Query(QueryType.PROJECT_GROUP_ID, groupId), artifactId);
        }

        public static Query[] create(Query groupQuery, String artifactId) throws IllegalArgumentException {
            if (!groupQuery.getType().equals((Object)QueryType.PROJECT_GROUP_ID)) {
                throw new IllegalArgumentException(groupQuery.getType().name() + " != " + QueryType.PROJECT_GROUP_ID.name());
            }
            return new Query[]{groupQuery, new Query(QueryType.PROJECT_ARTIFACT_ID, artifactId)};
        }
    }
}

