/* 
 * JBoss, Home of Professional Open Source 
 * Copyright 2012 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @author tags. All rights reserved. 
 * See the copyright.txt in the distribution for a 
 * full listing of individual contributors.
 *
 * This copyrighted material is made available to anyone wishing to use, 
 * modify, copy, or redistribute it subject to the terms and conditions 
 * of the GNU Lesser General Public License, v. 2.1. 
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details. 
 * You should have received a copy of the GNU Lesser General Public License, 
 * v.2.1 along with this distribution; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 */
package org.switchyard.common.property;

import java.util.Properties;

/**
 * Resolves properties from a Properties.
 *
 * @author David Ward &lt;<a href="mailto:dward@jboss.org">dward@jboss.org</a>&gt; &copy; 2012 Red Hat Inc.
 */
public class PropertiesPropertyResolver implements PropertyResolver {

    private final Properties _properties;

    /**
     * Construction with the specified Properties.
     * @param properties the specified Properties
     */
    public PropertiesPropertyResolver(Properties properties) {
        _properties = properties;
    }

    /**
     * Gets the Properties.
     * @return the Properties
     */
    public Properties getProperties() {
        return _properties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public final Object resolveProperty(String key) {
        return _properties.getProperty(key);
    }

}
