/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.switchyard.common.property.PropertyResolver;
import org.switchyard.common.property.SystemAndTestPropertyResolver;
import org.switchyard.common.property.SystemPropertyResolver;
import org.switchyard.common.property.TestPropertyResolver;

public final class Strings {
    public static final Map<String, String> DEFAULT_CLEANSE_REGEX_REPLACEMENTS;

    public static String trimToNull(String str) {
        if (str != null && (str = str.trim()).length() == 0) {
            str = null;
        }
        return str;
    }

    public static String repeat(String str, int repeatCount) {
        String repeated = "";
        if (str.isEmpty() || repeatCount <= 0) {
            return repeated;
        }
        do {
            repeated = repeated + str;
        } while (--repeatCount > 0);
        return repeated;
    }

    public static String cleanse(String str) {
        return Strings.cleanse(str, DEFAULT_CLEANSE_REGEX_REPLACEMENTS);
    }

    public static String cleanse(String str, Map<String, String> regexReplacements) {
        if (str != null) {
            for (Map.Entry<String, String> entry : regexReplacements.entrySet()) {
                String regex = entry.getKey();
                String replacement = entry.getValue();
                str = str.replaceAll(regex, replacement);
                String doubleReplacement = replacement + replacement;
                while (str.contains(doubleReplacement)) {
                    str = str.replaceAll(doubleReplacement, replacement);
                }
                if (str.startsWith(replacement)) {
                    str = str.substring(replacement.length());
                }
                if (!str.endsWith(replacement)) continue;
                str = str.substring(0, str.length() - 1);
            }
        }
        return str;
    }

    public static String cleanseTrimToNull(String str) {
        return Strings.trimToNull(Strings.cleanse(str));
    }

    public static String cleanseTrimToNull(String str, Map<String, String> regexReplacements) {
        return Strings.trimToNull(Strings.cleanse(str, regexReplacements));
    }

    public static List<String> splitTrimToNull(String str, String delim) {
        ArrayList<String> list = new ArrayList<String>();
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, delim);
            while (st.hasMoreTokens()) {
                String s = Strings.trimToNull(st.nextToken());
                if (s == null) continue;
                list.add(s);
            }
        }
        return Collections.unmodifiableList(list);
    }

    public static String[] splitTrimToNullArray(String str, String delim) {
        List<String> list = Strings.splitTrimToNull(str, delim);
        return list.toArray(new String[list.size()]);
    }

    public static Set<String> uniqueSplitTrimToNull(String str, String delim) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, delim);
            while (st.hasMoreTokens()) {
                String s = Strings.trimToNull(st.nextToken());
                if (s == null) continue;
                set.add(s);
            }
        }
        return Collections.unmodifiableSet(set);
    }

    public static String[] uniqueSplitTrimToNullArray(String str, String delim) {
        Set<String> set = Strings.uniqueSplitTrimToNull(str, delim);
        return set.toArray(new String[set.size()]);
    }

    public static String concat(String ... str) {
        return Strings.concat(null, str);
    }

    public static String concat(String delim, String ... str) {
        return Strings.concat(delim, true, str);
    }

    public static String concat(String delim, boolean trimToNull, String ... str) {
        if (str != null && str.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < str.length; ++i) {
                String s = str[i];
                if (trimToNull) {
                    s = Strings.trimToNull(s);
                }
                if (s == null) continue;
                sb.append(s);
                if (i >= str.length - 1) continue;
                sb.append(delim);
            }
            return sb.toString();
        }
        return null;
    }

    public static String replaceSystemProperties(String str) {
        return Strings.replaceProperties(str, SystemPropertyResolver.instance());
    }

    public static String replaceTestProperties(String str) {
        return Strings.replaceProperties(str, TestPropertyResolver.instance());
    }

    public static String replaceSystemAndTestProperties(String str) {
        return Strings.replaceProperties(str, SystemAndTestPropertyResolver.instance());
    }

    public static String replaceProperties(String str, PropertyResolver resolver) {
        if (str != null && resolver != null) {
            int r_pos;
            int l_pos = str.indexOf("${", 0);
            while (l_pos != -1 && (r_pos = str.indexOf(125, l_pos + 2)) != -1) {
                String def_val;
                String real_key;
                String prop_key = str.substring(l_pos + 2, r_pos);
                int c_pos = prop_key.indexOf(58);
                if (c_pos > -1) {
                    real_key = prop_key.substring(0, c_pos);
                    def_val = prop_key.substring(c_pos + 1, prop_key.length());
                } else {
                    real_key = prop_key;
                    def_val = null;
                }
                Object obj_val = resolver.resolveProperty(real_key);
                if (obj_val == null) {
                    obj_val = def_val;
                }
                if (obj_val != null) {
                    String str_val = obj_val.toString();
                    String begin = str.substring(0, l_pos);
                    str = begin + str_val + str.substring(r_pos + 1, str.length());
                    l_pos = str.indexOf("${", begin.length() + str_val.length());
                    continue;
                }
                l_pos = str.indexOf("${", l_pos + 2);
            }
        }
        return str;
    }

    private Strings() {
    }

    static {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("[\\W_]", "-");
        DEFAULT_CLEANSE_REGEX_REPLACEMENTS = Collections.unmodifiableMap(map);
    }
}

