/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.version;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.switchyard.common.version.Queries;
import org.switchyard.common.version.Version;
import org.switchyard.common.version.VersionFactory;

public final class Versions {
    private static final Logger LOGGER = Logger.getLogger(Versions.class);
    private static final String NOTIFICATION_PREFIX = "SwitchYard version ";

    private Versions() {
    }

    public static String getSwitchYardVersion() {
        return VersionFactory.instance().getVersion(Queries.Projects.SWITCHYARD_COMMON).getProject().getVersion();
    }

    public static String getSwitchYardNotification() {
        return NOTIFICATION_PREFIX + Versions.getSwitchYardVersion();
    }

    public static void logSwitchYardNotification(Logger logger, Level level) {
        if (logger.isEnabledFor((Priority)level)) {
            logger.log((Priority)level, (Object)Versions.getSwitchYardNotification());
        }
    }

    public static void logSwitchYardNotification(Logger logger) {
        Versions.logSwitchYardNotification(logger, Level.INFO);
    }

    public static void logSwitchYardNotification() {
        Versions.logSwitchYardNotification(LOGGER);
    }

    public static void printSwitchYardNotification(Writer w) {
        PrintWriter pw = w instanceof PrintWriter ? (PrintWriter)w : new PrintWriter(w);
        pw.println(Versions.getSwitchYardNotification());
        pw.flush();
    }

    public static void printSwitchYardNotification(OutputStream os) {
        Versions.printSwitchYardNotification(new PrintWriter(os));
    }

    public static void printSwitchYardNotification() {
        Versions.printSwitchYardNotification(System.out);
    }

    public static Set<Version> getSwitchYardVersions() {
        return VersionFactory.instance().getVersions(Queries.Projects.SWITCHYARD);
    }

    public static void logSwitchYardVersions(Logger logger, Level level) {
        if (logger.isEnabledFor((Priority)level)) {
            for (Version version : Versions.getSwitchYardVersions()) {
                logger.log((Priority)level, (Object)version);
            }
        }
    }

    public static void logSwitchYardVersions(Logger logger) {
        Versions.logSwitchYardVersions(logger, Level.INFO);
    }

    public static void logSwitchYardVersions() {
        Versions.logSwitchYardVersions(LOGGER);
    }

    public static void printSwitchYardVersions(Writer w) {
        PrintWriter pw = w instanceof PrintWriter ? (PrintWriter)w : new PrintWriter(w);
        for (Version version : Versions.getSwitchYardVersions()) {
            pw.println(version);
        }
        pw.flush();
    }

    public static void printSwitchYardVersions(OutputStream os) {
        Versions.printSwitchYardVersions(new PrintWriter(os));
    }

    public static void printSwitchYardVersions() {
        Versions.printSwitchYardVersions(System.out);
    }

    public static void main(String ... args) {
        Versions.printSwitchYardNotification();
        Versions.printSwitchYardVersions();
    }
}

