/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.switchyard.common.property.CompoundPropertyResolver;
import org.switchyard.common.property.PropertyResolver;
import org.switchyard.common.property.SystemAndTestPropertyResolver;
import org.switchyard.common.property.SystemPropertyResolver;
import org.switchyard.common.property.TestPropertyResolver;

public final class Strings {
    public static final Map<String, String> DEFAULT_CLEANSE_REGEX_REPLACEMENTS;
    private static final Pattern DOUBLE_DOLLAR_LEFT_CURLY_PATTERN;
    private static final Pattern INNER_DOLLAR_CURLIES_PATTERN;
    private static final Pattern SINGLE_COLON_PATTERN;
    private static final String PENCIL;
    private static final String DOLLAR = "\\$";
    private static final String LEFT_CURLY = "{";
    private static final String RIGHT_CURLY = "}";
    private static final String PENCIL_LEFT_CURLY;

    public static String trimToNull(String str) {
        if (str != null && (str = str.trim()).length() == 0) {
            str = null;
        }
        return str;
    }

    public static String repeat(String str, int repeatCount) {
        String repeated = "";
        if (str.isEmpty() || repeatCount <= 0) {
            return repeated;
        }
        do {
            repeated = repeated + str;
        } while (--repeatCount > 0);
        return repeated;
    }

    public static String cleanse(String str) {
        return Strings.cleanse(str, DEFAULT_CLEANSE_REGEX_REPLACEMENTS);
    }

    public static String cleanse(String str, Map<String, String> regexReplacements) {
        if (str != null) {
            for (Map.Entry<String, String> entry : regexReplacements.entrySet()) {
                String regex = entry.getKey();
                String replacement = entry.getValue();
                str = str.replaceAll(regex, replacement);
                String doubleReplacement = replacement + replacement;
                while (str.contains(doubleReplacement)) {
                    str = str.replaceAll(doubleReplacement, replacement);
                }
                if (str.startsWith(replacement)) {
                    str = str.substring(replacement.length());
                }
                if (!str.endsWith(replacement)) continue;
                str = str.substring(0, str.length() - 1);
            }
        }
        return str;
    }

    public static String cleanseTrimToNull(String str) {
        return Strings.trimToNull(Strings.cleanse(str));
    }

    public static String cleanseTrimToNull(String str, Map<String, String> regexReplacements) {
        return Strings.trimToNull(Strings.cleanse(str, regexReplacements));
    }

    public static List<String> splitTrimToNull(String str, String delim) {
        ArrayList<String> list = new ArrayList<String>();
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, delim);
            while (st.hasMoreTokens()) {
                String s = Strings.trimToNull(st.nextToken());
                if (s == null) continue;
                list.add(s);
            }
        }
        return Collections.unmodifiableList(list);
    }

    public static String[] splitTrimToNullArray(String str, String delim) {
        List<String> list = Strings.splitTrimToNull(str, delim);
        return list.toArray(new String[list.size()]);
    }

    public static Set<String> uniqueSplitTrimToNull(String str, String delim) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, delim);
            while (st.hasMoreTokens()) {
                String s = Strings.trimToNull(st.nextToken());
                if (s == null) continue;
                set.add(s);
            }
        }
        return Collections.unmodifiableSet(set);
    }

    public static String[] uniqueSplitTrimToNullArray(String str, String delim) {
        Set<String> set = Strings.uniqueSplitTrimToNull(str, delim);
        return set.toArray(new String[set.size()]);
    }

    public static String concat(String ... str) {
        return Strings.concat(null, str);
    }

    public static String concat(String delim, String ... str) {
        return Strings.concat(delim, true, str);
    }

    public static String concat(String delim, boolean trimToNull, String ... str) {
        if (str != null && str.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < str.length; ++i) {
                String s = str[i];
                if (trimToNull) {
                    s = Strings.trimToNull(s);
                }
                if (s == null) continue;
                sb.append(s);
                if (i >= str.length - 1) continue;
                sb.append(delim);
            }
            return sb.toString();
        }
        return null;
    }

    public static String replaceSystemProperties(String str) {
        return Strings.replaceProperties(str, SystemPropertyResolver.INSTANCE);
    }

    public static String replaceTestProperties(String str) {
        return Strings.replaceProperties(str, TestPropertyResolver.INSTANCE);
    }

    public static String replaceSystemAndTestProperties(String str) {
        return Strings.replaceProperties(str, SystemAndTestPropertyResolver.INSTANCE);
    }

    public static String replaceProperties(String str, PropertyResolver ... resolvers) {
        if (str != null) {
            PropertyResolver resolver = CompoundPropertyResolver.compact(resolvers);
            boolean penciled = false;
            while (true) {
                String str_val;
                String def_val;
                String real_key;
                int r_pos;
                Matcher idc_mat;
                Matcher ddlc_mat;
                if ((ddlc_mat = DOUBLE_DOLLAR_LEFT_CURLY_PATTERN.matcher(str)).find()) {
                    str = ddlc_mat.replaceAll(PENCIL_LEFT_CURLY);
                    penciled = true;
                }
                if (!(idc_mat = INNER_DOLLAR_CURLIES_PATTERN.matcher(str)).find()) break;
                int l_pos = idc_mat.start();
                String prop_key = str.substring(l_pos + 2, r_pos = idc_mat.end() - 1);
                Matcher sc_mat = SINGLE_COLON_PATTERN.matcher(prop_key);
                if (sc_mat.find()) {
                    int sc_pos = sc_mat.start() + 1;
                    real_key = prop_key.substring(0, sc_pos);
                    def_val = prop_key.substring(sc_pos + 1, prop_key.length());
                } else {
                    real_key = prop_key;
                    def_val = null;
                }
                Object obj_val = resolver.resolveProperty(real_key);
                if (obj_val == null) {
                    obj_val = def_val;
                }
                if (obj_val != null) {
                    str_val = obj_val.toString();
                } else {
                    str_val = PENCIL_LEFT_CURLY + real_key + RIGHT_CURLY;
                    penciled = true;
                }
                str = str.substring(0, l_pos) + str_val + str.substring(r_pos + 1, str.length());
            }
            if (penciled) {
                str = str.replaceAll(PENCIL, DOLLAR);
            }
        }
        return str;
    }

    public static String replaceProperties(String str, Collection<PropertyResolver> resolvers) {
        return Strings.replaceProperties(str, CompoundPropertyResolver.compact(resolvers));
    }

    private Strings() {
    }

    static {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("[\\W_]", "-");
        DEFAULT_CLEANSE_REGEX_REPLACEMENTS = Collections.unmodifiableMap(map);
        DOUBLE_DOLLAR_LEFT_CURLY_PATTERN = Pattern.compile("\\$\\$\\{");
        INNER_DOLLAR_CURLIES_PATTERN = Pattern.compile("\\$\\{[[^\\$\\{]&&[^\\}]]*\\}");
        SINGLE_COLON_PATTERN = Pattern.compile("[^:+]:[^:+]");
        PENCIL = String.valueOf('\u270f');
        PENCIL_LEFT_CURLY = PENCIL + LEFT_CURLY;
    }
}

